#!/usr/bin/perl
#    OpaL Perl Modules
#    Copyright (C) 2000  Ola Lundqvist
#    $Id: read.pm,v 1.11 2002/01/22 21:14:46 ola Exp $
#    For full COPYRIGHT notice see the COPYING document.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of either:
#
#	a) the GNU General Public License as published by the Free
#	Software Foundation; either version 1, or (at your option) any
#	later version, or
#
#	b) the "Artistic License" which comes with this Kit.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
#    the GNU General Public License or the Artistic License for more details.
#
#
#    For more information take a look at the official homepage at:
#      http://www.opal.dhs.org/programs/opalmod
#    or contact the author at:
#      opal@debian.org
#

package OpaL::read;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use POSIX qw(strftime);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw( );
@EXPORT_OK = qw(readfile readscalarfile readfileline
		readcommand readscalarcommand readcommandline);

# If you are using CVS/RCS this can be quite handy.
#$VERSION = do{my@r=q$Revision: 1.11 $=~/\d+/g;sprintf '%d.'.'%02d'x$#r,@r};

# If that is not what you want use this instead. Will be rewritten by
# create release.
my $version = '0.01';
$VERSION = $version;

###############################################################################
############################ PACKAGE GLOBALS ##################################
###############################################################################

# First exported ones (those in @EXPORT or @EXPORT_OK)

# Then package other global ones. (not exported ones)
# Can be accessed through $OpaL::read::variablename

# All file-scooped variables must be created before any method that uses them.
# my $myvar = '';

###############################################################################
########################### PRELOADED METHODS #################################
###############################################################################
# Preloaded methods go here.





# Autoload methods go after =cut, and are processed by the autosplit program.

# Modules must return true.
1;
__END__

###############################################################################
############################# DOCUMENTATION ###################################
###############################################################################
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

OpaL::read - Perl extension for reading files and commands.

=head1 SYNOPSIS

  use OpaL::read qw(functions);

No functions or variables are exported automaticly so you have to specify
them here. 

=head1 DESCRIPTION

OpaL::read is used for reading files and commands.

All functions are autoloaded so they will not be loaded into memory if you
have not used them before.

=head1 FUNCTIONS

=over 4

=item B<readfile>

Reads the content of the specified file and returns a list with the all lines.

USAGE:
    @foo = C<readfile>($filename);

=item B<readfileline>

Reads the first line of the specified file and returns a scalar with that line.

USAGE:
    $foo = C<readfileline>($filename);

=item B<readscalarfile>

Reads the content of the specified file and returns a scalar with the entire content.

USAGE:
    $foo = C<readscalarfile>("filename");

=item B<readcommand>

Reads the content from the output of the specified command and returns a list with the all lines.

USAGE:
    @foo = C<readcommand>("command");

=item B<readcommandline>

Reads the first line from output of the specified command and returns a scalar with that line.

USAGE:
    $foo = C<readcommandline>("command)";

=item B<readscalarfile>

Reads the content for the output of the specified file and returns a scalar with the entire content.

USAGE:
    $foo = C<readscalarcommand>($command);

=back

=head1 AUTHOR

Ola Lundqvist <opal@debian.org>

=head1 SEE ALSO

perl(1).

=cut

###############################################################################
########################### AUTOLOAD METHODS ##################################
###############################################################################

###############################################################################
# Name:		readcommand
# Description:	Executes a program and read the piped result.
# Returns:	Array of lines.
# Arguments:	$command_string
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-05-01
#		2000-06-27	Better argument definition.
###############################################################################
sub readcommand {#($) {
    my $cmd = shift;
    open C, "$cmd |";
    my @t = <C>;
    close (C);
    return @t;
}

###############################################################################
# Name:		readfile
# Description:	Reads a file.
# Returns:	Array of lines.
# Arguments:	$filename
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-05-13
#		2000-06-25	Removed &action from open. Not working.
#		2000-06-27	Better argument definition.
#				Removed errlvl.
###############################################################################
sub readfile {#($) {
    my $file = shift;
    open C, $file;
    my @t = <C>;
    close (C);
    return @t;
}

###############################################################################
# Name:		readfileline
# Description:	Reads a file.
# Returns:	The first line.
# Arguments:	$filename
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-05-13
#		2000-07-06	Removed &action from open. Not working.
#				Better argument definition.
#				Removed errlvl.
###############################################################################
sub readfileline { #($){
    my $file = shift;
    open C, $file;
    my $t = <C>;
    close (C);
    return $t;
}

###############################################################################
# Name:		readscalarfile
# Description:	Reads a file.
# Returns:	Entire file in scalar.
# Arguments:	$filename
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-05-13
#		2000-06-25	Removed &action from open. Not working.
#		2000-06-27	Better argument definition.
#				Removed errlvl.
###############################################################################
sub readscalarfile {#($) {
    my $file = shift;
    open C, $file;
    my $m = $/;
    undef $/;
    my $t = <C>;
    close (C);
    $/ = $m;
    return $t;
}

###############################################################################
# Name:		readscalarcommand
# Description:	Reads a command output into a scalar.
# Returns:	Entire file in scalar.
# Arguments:	$command
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-06-27	Wrote it.
###############################################################################
sub readscalarcommand {#($) {
    my $cmd = shift;
    open C, "$cmd |";
    my $m = $/;
    undef $/;
    my $t = <C>;
    close (C);
    $/ = $m;
    return $t;
}

###############################################################################
# Name:		readcommandline
# Description:	Executes a program and read the piped result.
# Returns:	The first line.
# Arguments:	$command_string
# Author:	Ola Lundqvist <opal@debian.org>
# Date:		2000-05-01
#		2000-06-27	Better argument definition.
###############################################################################
sub readcommandline {#($) {
    my $cmd = shift;
    open C, "$cmd |";
    my $t = <C>;
    close (C);
    return $t;
}

