#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10260);
 script_cve_id("CAN-1999-0098");
 name["english"] = "HELO overflow";
 name["francais"] = "Dpassement de HELO";
 script_name(english:name["english"],
 	     francais:name["francais"]);
 
 desc["english"] = "
The remote STMP server seems to allow remote users to
send mail anonymously by providing a too long argument
to the HELO command (more than 1024 chars).

This problem may allow bad guys to send hate
mail, or threatening mail using your server
and keep their anonymity.

Risk factor : Low.

Solution : If you are using sendmail, upgrade to
version 8.9.x. If you do not run sendmail, contact
your vendor.";


 desc["francais"] = "
Le serveur SMTP distant semble permettre  n'importe qui
d'envoyer des mails de maniere anonyme en donnant un
argument trop long  la commande HELO (plus de 1024
caractres).

Ce problme peut permettre  des personnes mal intentionnes
d'envoyer des messages agressifs ou menacant en utilisant
votre serveur de mail, et en gardant leur anonymat.

Facteur de risque : Faible.

Solution : Si vous utilisez sendmail, mettez le  jour
en version 8.9.x. Si vous n'utilisez pas sendmail,
contactez votre vendeur.";


 script_description(english:desc["english"],
 	 	    francais:desc["francais"]);
		    
 
 summary["english"] = "Checks if the remote mail server can be used to send anonymous mail"; 
 summary["francais"] = "Vrifie si le serveur de mail distant peut etre utilis pour envoyer du mail anonyme";
 script_summary(english:summary["english"],
 		 francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 
 family["english"] = "SMTP problems";
 family["francais"] = "Problmes SMTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "sendmail_expn.nasl", "smtpserver_detect.nasl");
 script_exclude_keys("Sendmail/fake", "Sendmail/qmail", "Sendmail/postfix");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

fake = get_kb_item("Sendmail/fake");
if(fake)exit(0);

port = get_kb_item("Services/smtp");
if(!port)port = 25;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
 data = recv(socket:soc, length:1024);
 crp = string("HELO ", crap(1030), "\r\n");
 send(socket:soc, data:crp);
 data = recv_line(socket:soc, length:4);
 if(data == "250 ")security_warning(port);
 close(soc);
 }
}
