#
# Copyright 2000 by Hendrik Scholz <hendrik@scholz.net> 
#
# See the Nessus Scripts License for details
#
# This script is based on the webserver detect script from SecuriTeam.
# But this one uses an HTTP 1.0 request :-)
#

if(description)
{
 script_id(10107);
 
 name["english"] = "HTTP Server type and version";
 script_name(english:name["english"]);
 
 desc["english"] = "This detects the HTTP Server's type and version.

Solution: Configure your server to use an alternate name like 
          'Wintendo httpD w/Dotmatrix display'.
          Be sure to remove common logos apache.gif.

Risk factor : Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "HTTP Server type and version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2000 Securiteam / modified by H. Scholz");
 family["english"] = "General";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "httpver.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

 port = get_kb_item("Services/www");
 if (!port) port = 80;

 if (get_port_state(port))
 {
  soctcp80 = open_sock_tcp(port);

  if (soctcp80)
  {
   data = http_get(item:"/", port:port);
   resultsend = send(socket:soctcp80, data:data);
   resultrecv = recv(socket:soctcp80, length:8192);
   if ("Server: " >< resultrecv)
   {
    svrline = egrep(pattern:"^Server:", string:resultrecv);
    svr = ereg_replace(pattern:"^Server: (.*)$", string:svrline, replace:"\1");
    report = string("The remote web server type is :\n\n");
    report = report + svr;
    report = report + string("\n", "We recommend that you configure your web server to return\n", "bogus versions, so that it makes the cracker job more difficult\n");
    security_note(port:port, data:report);

    #
    # put the name of the web server in the KB
    #
    if(egrep(pattern:"^Server:.*Domino.*", string:svrline))
       set_kb_item(name:"www/domino", value:TRUE);

    if(egrep(pattern:"^Server:.*Apache.*", string:svrline))
       set_kb_item(name:"www/apache", value:TRUE);

    if(egrep(pattern:"^Server:.*IIS.*", string:svrline))
       set_kb_item(name:"www/iis", value:TRUE);

    if(egrep(pattern:"^Server.*Zope.*", string:svrline))
       set_kb_item(name:"www/zope", value:TRUE);

    if(egrep(pattern:"^Server:.*CERN.*", string:svrline))
       set_kb_item(name:"www/cern", value:TRUE);

    if(egrep(pattern:"^Server:.*Zeus.*", string:svrline))
       set_kb_item(name:"www/zeus", value:TRUE);

     if(egrep(pattern:"^Server:.*WebSitePro.*", string:svrline))
       set_kb_item(name:"www/websitepro", value:TRUE);

    if(egrep(pattern:"^Server:.*NCSA.*", string:svrline))
       set_kb_item(name:"www/ncsa", value:TRUE);

   if(egrep(pattern:"^Server:.*Netscape-Enterprise.*", string:svrline))
       set_kb_item(name:"www/iplanet", value:TRUE);


   } 
  }
  close(soctcp80);
 }
