# This script was written by Yoav Goldberg <yoavg@securiteam.com>

# (slightly modified by rd)

#
# Body of a script
#
if(description)
{
 script_id(10694);
 script_name(english:"GuildFTPD Directory Traversal");
 
 desc = "
Version 0.97 of GuildFTP was detected. A security vulnerability in
this product allows anyone with a valid FTP login to read arbitrary 
files on the system.

Solution: Upgrade your FTP server.
More Information : http://www.securiteam.com/windowsntfocus/5CP0S2A4AU.html

Risk factor : High";

 script_description(english:desc);

 script_summary(english:"This script detects the presence of GuildFTP daemon version 0.97");
 script_category(ACT_GATHER_INFO);
 script_family(english:"FTP");
 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");

 script_dependencies("find_service.nes");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# Actual script starts here
#


port = get_kb_item("Services/ftp");
if(!port)port = 21;

if (get_port_state(port))
{
	soc = open_sock_tcp(port);
	if(soc)
	{
	ret = recv(socket:soc, length:1024);
	close(soc);
	if ("GuildFTPD FTP" >< ret) 
		{
		if ("Version 0.97" >< ret)
			{
			 security_hole(port);
			}
		}
	}
}
