/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2012 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _POSIX_C_SOURCE	200809L

#include "internal.h"

_NACORE_DEF nacore_mutex
nacore_mutex_new()
{
	pthread_mutexattr_t attr;
	nacore_mutex ret;
	int err;

	ret = malloc(sizeof(pthread_mutex_t));
	if (ret == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	if (pthread_mutexattr_init(&attr) != 0)
	  {
		free(ret);
		errno = ENOMEM;
		return NULL;
	  }

	pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_ERRORCHECK);
	err = pthread_mutex_init((pthread_mutex_t *)ret, &attr);
	pthread_mutexattr_destroy(&attr);
	if (err != 0)
	  {
		free(ret);
		errno = err;
		return NULL;
	  }

	return ret;
}

_NACORE_DEF void
nacore_mutex_free(nacore_mutex mutex)
{
	pthread_mutex_destroy((pthread_mutex_t *)mutex);

	free(mutex);
}

_NACORE_DEF int
nacore_mutex_lock(nacore_mutex mutex)
{
	return pthread_mutex_lock((pthread_mutex_t *)mutex);
}

_NACORE_DEF int
nacore_mutex_trylock(nacore_mutex mutex)
{
	return pthread_mutex_trylock((pthread_mutex_t *)mutex);
}

_NACORE_DEF void
nacore_mutex_unlock(nacore_mutex mutex)
{
	pthread_mutex_unlock((pthread_mutex_t *)mutex);
}
