// pvoceditor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// DataEditor subclass for processing PvocData objects.

#ifndef PVOCEDITOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVOCEDITOR_H

#include "editor.h"

class PvocEditor : public DataEditor {
	typedef DataEditor Super;
public:
	static Controller* new_File(Controller *);
	redefined Status newFile();

	Status audition();
	Status harmonicShift();
	Status stretchShift();
	Status compressOrExpand();
	Status crossfadeSpectrum();
	redefined Status setDataOptions();
protected:
	PvocEditor(Controller *c) : DataEditor(c) {}
	PvocEditor(Controller *c, const Data *d) : DataEditor(c, d) {}

	redefined boolean keyCommand(unsigned long);
public:
	redefined const MenuBarInfo *menuBarInfo() const;
	static DataEditor* new_DataEditor1(Controller *);
	static DataEditor* new_DataEditor2(Controller *, const Data *);
private:	
	friend class Controller;
	redefined Data *newModel();
};

#endif
