// menus.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include <InterViews/action.h>
#include <InterViews/box.h>
#include <InterViews/glue.h>
#include "menus.h"
#include "vmessage.h"
#include "cmdstate.h"

PulldownCommandMenu::PulldownCommandMenu(const char* str, boolean enabled)
		: PulldownMenu(cmdLabel = new VMessage(str, Left, 2, enabled)) {
	SetClassName("PulldownCommandMenu");
	SetInstance(str);
	PulldownMenu::Enable(enabled);
}

void
PulldownCommandMenu::Enable(boolean isEnabled) {
	cmdLabel->enable(isEnabled);
	PulldownMenu::Enable(isEnabled);
}

//********

PullrightCommandMenu::PullrightCommandMenu(const char* str, boolean enabled)
		: PullrightMenu((Interactor *) nil) {
	SetClassName("PullrightCommandMenu");
	SetInstance(str);
	Insert( new HBox(
		cmdLabel = new VMessage(str, Left, 2, /* hfil, */ enabled),
		new Message("   ", Center, 2, hfil),
		arrowLabel = new VMessage("->", Right, 2, /* hfil, */ enabled)
		)
	);
	PullrightMenu::Enable(enabled);
}

void
PullrightCommandMenu::Enable(boolean isEnabled) {
	cmdLabel->enable(isEnabled);
	arrowLabel->enable(isEnabled);
	PullrightMenu::Enable(isEnabled);
}

//********

Command::Command(const char* str,
				 const char* keystr,
				 unsigned activeStateFlags,
				 Action* action,
				 CommandState *state)
		 : MenuItem((Interactor *) nil),
		   _activeFlags(activeStateFlags), _action(action), _cmdState(state) {
	SetClassName("Command");
	SetInstance(str);
	Insert( new HBox(
		_cmdMessage = new VMessage(str, Left, 2, /* hfil, */ true),
		new Message("   ", Center, 2, hfil),
		_keyMessage = new VMessage(keystr, Right, 2, /* hfil, */ true)
		)
	);
	_action->ref();
	_cmdState->Attach(this);
	_cmdState->ref();
	Update();
}

Command::~Command() {
	_cmdState->Detach(this);
	Resource::unref(_action);
	Resource::unref(_cmdState);
}

// If the current command state matches our state, we are active, else not.

void
Command::Update() {
	Enable(_cmdState->IsSet(_activeFlags));	
}

void
Command::Do() {
	_action->execute();
}

void
Command::Enable(boolean isEnabled) {
	_cmdMessage->enable(isEnabled);
	_keyMessage->enable(isEnabled);
	Control::Enable(isEnabled);
}
