/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*----------------------------------------------------------------------*
 * Originally written:
 * 2002   Alexis <materm@tuxfamily.org>
 *
 *----------------------------------------------------------------------*/
 
/* 
 * $Id: notebook2.h,v 1.8 2003/11/23 08:08:36 alexis Exp $
 */

#ifndef _NOTEBOOK_H
#define _NOTEBOOK_H

#include "rxvt.h"

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>

/* init */
extern void init_notebook(void);

/* ajoute un onglet a la fin */
extern void append_page(int index);

/* cb appel qd on clique sur del term */
extern void destroy_page(int page,pid_t pid);

// libere ttes les ressources associees a un vt
extern void remove_page(int page);

/* desactive la page active et active la page_num */
extern void activate_page(int page);

/* execute une action si le bouton presse l'a ete dans 
 * une zone sensible de la fenetre
 */
extern void dispatch_button_press(int x,int y,pid_t pid);

/* refresh the thumb_bar
 */
extern void thumb_bar_expose();

/* create the thumb_bar
 */
extern void create_thumb_bar(XSizeHints *szHints);

/* decale les onglets de 1 cran a gauche ou a droite
 * direction = 0 -> left
 * direction = 1 -> right
 * x -> offset 
 */
extern void page_shift(unsigned int direction,int x);

extern void page_left_shift(int x);

extern void page_right_shift(int x);

extern void resize_thumb_bar(XEvent * ev);

extern void activate_page_num(int page);
#endif
