/*
 * Decompiled with CFR 0.152.
 */
package logformat.clogTOdrawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Composite;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.clog.MixedDataInputStream;
import logformat.clog.RecColl;
import logformat.clog.RecComm;
import logformat.clog.RecDefMsg;
import logformat.clog.RecDefState;
import logformat.clog.RecEvent;
import logformat.clog.RecHeader;
import logformat.clog.RecMsg;
import logformat.clog.RecRaw;
import logformat.clog.RecSrc;
import logformat.clog.RecTshift;
import logformat.clogTOdrawable.ColorNameMap;
import logformat.clogTOdrawable.ObjDef;
import logformat.clogTOdrawable.ObjMethod;
import logformat.clogTOdrawable.Topo_Arrow;
import logformat.clogTOdrawable.Topo_State;
import logformat.clogTOdrawable.TwoEventsMatching;

public class InputLog
extends logformat.clog.InputLog
implements InputAPI {
    private MixedDataInputStream blk_ins;
    private long total_bytesize;
    private int rectype;
    private Map evtdefs = new HashMap();
    private List topos = new ArrayList();
    private ObjDef statedef;
    private ObjDef arrowdef;
    private Primitive drawobj;
    private RecHeader header;
    private RecDefState def;
    private RecRaw raw;
    private RecColl coll;
    private RecComm comm;
    private RecEvent event;
    private RecMsg msg;
    private RecSrc src;
    private RecTshift tshift;
    private Topo_Arrow arrowform;
    private Topo_State stateform;
    private ObjMethod obj_fn;
    private Object[] arglist;
    private boolean isFirstPeekForCategory;
    private int num_topology_returned;

    public InputLog(String string) {
        super(string);
        ColorNameMap.initMapFromRGBtxt("jumpshot.colors");
        ObjDef.setFirstNextCategoryIndex(0);
        this.arrowform = new Topo_Arrow();
        int n = ObjDef.getNextCategoryIndex();
        this.arrowdef = new ObjDef(n, new RecDefMsg(), this.arrowform, 3);
        this.arrowdef.setInfoKeys("msg_tag=%d, msg_size=%d");
        this.arrowdef.setColor(new ColorAlpha(this.arrowdef.getColor(), 255));
        this.arrowform.setCategory(this.arrowdef);
        this.evtdefs.put(this.arrowdef.start_evt, this.arrowform.getStartEventObjMethod());
        this.evtdefs.put(this.arrowdef.final_evt, this.arrowform.getFinalEventObjMethod());
        List list = RecDefState.getMPIinitUndefinedStateDefs();
        list.addAll(RecDefState.getUSERinitUndefinedStateDefs());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.def = (RecDefState)iterator.next();
            this.stateform = new Topo_State();
            n = ObjDef.getNextCategoryIndex();
            this.statedef = new ObjDef(n, this.def, this.stateform, 1);
            this.stateform.setCategory(this.statedef);
            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
        }
        this.header = new RecHeader();
        this.def = new RecDefState();
        this.raw = new RecRaw();
        this.coll = new RecColl();
        this.comm = new RecComm();
        this.event = new RecEvent();
        this.msg = new RecMsg();
        this.src = new RecSrc();
        this.tshift = new RecTshift();
        this.arglist = new Object[2];
        this.total_bytesize = 0L;
        this.num_topology_returned = 0;
        this.isFirstPeekForCategory = true;
        this.blk_ins = super.getBlockStream();
    }

    public Kind peekNextKind() {
        if (this.num_topology_returned < 3) {
            return Kind.TOPOLOGY;
        }
        if (this.isFirstPeekForCategory) {
            return Kind.CATEGORY;
        }
        while (this.blk_ins != null) {
            this.rectype = 0;
            block17: while (this.rectype != -1 && this.rectype != -2) {
                int n = this.header.readFromDataStream(this.blk_ins);
                this.total_bytesize += (long)n;
                this.rectype = this.header.getRecType();
                switch (this.rectype) {
                    case 6: {
                        n = this.def.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.def.startetype);
                        ObjMethod objMethod2 = (ObjMethod)this.evtdefs.get(this.def.endetype);
                        if (objMethod == null || objMethod2 == null) {
                            this.stateform = new Topo_State();
                            int n2 = ObjDef.getNextCategoryIndex();
                            this.statedef = new ObjDef(n2, this.def, this.stateform, 1);
                            this.stateform.setCategory(this.statedef);
                            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
                            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
                        } else if (objMethod.obj == objMethod2.obj) {
                            this.stateform = (Topo_State)objMethod.obj;
                            this.statedef = (ObjDef)this.stateform.getCategory();
                            this.statedef.setName(this.def.description);
                            this.statedef.setColor(ColorNameMap.getColorAlpha(this.def.color));
                        } else {
                            System.err.println("**** Error! " + objMethod.obj + "!=" + objMethod2.obj);
                        }
                        return Kind.CATEGORY;
                    }
                    case 1: {
                        n = this.raw.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        int n3 = this.raw.etype;
                        if (n3 == -201 || n3 == 0) continue block17;
                        ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.raw.etype);
                        this.arglist[0] = this.header;
                        this.arglist[1] = this.raw;
                        this.drawobj = null;
                        try {
                            this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            System.err.println("Offending RecRaw = " + this.raw);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            System.err.println("Offending RecHeader = " + this.header);
                            System.err.println("Offending RecRaw = " + this.raw);
                            System.exit(1);
                        }
                        if (this.drawobj == null) continue block17;
                        return Kind.PRIMITIVE;
                    }
                    case 3: {
                        n = this.coll.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case 4: {
                        n = this.comm.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case 5: {
                        n = this.event.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case 2: {
                        n = this.msg.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case 7: {
                        n = this.src.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case 8: {
                        n = this.tshift.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)n;
                        continue block17;
                    }
                    case -1: {
                        this.blk_ins = super.getBlockStream();
                        continue block17;
                    }
                    case -2: {
                        this.blk_ins = null;
                        continue block17;
                    }
                }
                System.err.println("Unknown Record type = " + this.rectype);
            }
        }
        return Kind.EOF;
    }

    public Topology getNextTopology() {
        switch (this.num_topology_returned) {
            case 0: {
                this.num_topology_returned = 1;
                return Topology.EVENT;
            }
            case 1: {
                this.num_topology_returned = 2;
                return Topology.STATE;
            }
            case 2: {
                this.num_topology_returned = 3;
                return Topology.ARROW;
            }
        }
        System.err.println("All Topology Names have been returned");
        return null;
    }

    public Category getShadowCategoryForTopology(Topology topology) {
        ColorAlpha colorAlpha = new ColorAlpha(ColorAlpha.yellow, 255);
        ColorAlpha colorAlpha2 = new ColorAlpha(ColorAlpha.white, 255);
        ColorAlpha colorAlpha3 = new ColorAlpha(ColorAlpha.white, 191);
        if (topology.isEvent()) {
            Category category = new Category(-1, "Preview_" + topology.toString(), topology, colorAlpha3, 5);
            return category;
        }
        if (topology.isArrow()) {
            Category category = new Category(-2, "Preview_" + topology.toString(), topology, colorAlpha, 5);
            return category;
        }
        if (topology.isState()) {
            Category category = new Category(-3, "Preview_" + topology.toString(), topology, colorAlpha3, 5);
            return category;
        }
        return null;
    }

    public Category getNextCategory() {
        if (this.isFirstPeekForCategory) {
            this.isFirstPeekForCategory = false;
            this.topos.add(this.arrowdef.getTopology());
            return this.arrowdef;
        }
        this.topos.add(this.statedef.getTopology());
        return this.statedef;
    }

    public Primitive getNextPrimitive() {
        return this.drawobj;
    }

    public Composite getNextComposite() {
        return null;
    }

    public YCoordMap getNextYCoordMap() {
        return null;
    }

    public long getTotalBytesRead() {
        return this.total_bytesize;
    }

    public List getAllUsedTopos() {
        return this.topos;
    }

    public long getNumberOfUnMatchedEvents() {
        int n = 0;
        Iterator iterator = this.topos.iterator();
        while (iterator.hasNext()) {
            n += ((TwoEventsMatching)iterator.next()).getPartialObjects().size();
        }
        return n;
    }
}

