/* mg-graph.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __MG_GRAPH_H_
#define __MG_GRAPH_H_

#include <libmergeant/mg-base.h>
#include <libmergeant/mg-defs.h>

/* Implements the MgXmlStorage interface */

G_BEGIN_DECLS

#define MG_GRAPH_TYPE          (mg_graph_get_type())
#define MG_GRAPH(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_graph_get_type(), MgGraph)
#define MG_GRAPH_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_graph_get_type (), MgGraphClass)
#define IS_MG_GRAPH(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_graph_get_type ())

/* error reporting */
extern GQuark mg_graph_error_quark (void);
#define MG_GRAPH_ERROR mg_graph_error_quark ()

enum
{
	MG_GRAPH_XML_LOAD_ERROR
};


/* different possible types for a query */
typedef enum {
        MG_GRAPH_DB_RELATIONS,
	MG_GRAPH_QUERY_JOINS,
        MG_GRAPH_MODELLING /* for future extensions */
} MgGraphType;


/* struct for the object's data */
struct _MgGraph
{
	MgBase           object;
	MgGraphPrivate  *priv;
};

/* struct for the object's class */
struct _MgGraphClass
{
	MgBaseClass   class;
	
	/* signals */
	void        (*item_added)   (MgGraph *graph, MgGraphItem *item);
	void        (*item_dropped) (MgGraph *graph, MgGraphItem *item);
	void        (*item_moved)   (MgGraph *graph, MgGraphItem *item);
};

guint            mg_graph_get_type            (void);

GObject         *mg_graph_new                 (MgConf *conf, MgGraphType type);
MgGraphType      mg_graph_get_graph_type      (MgGraph *graph);

void             mg_graph_add_item            (MgGraph *graph, MgGraphItem *item);
void             mg_graph_del_item            (MgGraph *graph, MgGraphItem *item);
MgGraphItem     *mg_graph_get_item_from_obj   (MgGraph *graph, MgBase *ref_obj, gboolean create_if_needed);
GSList          *mg_graph_get_items           (MgGraph *graph);

G_END_DECLS

#endif
