/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: param.h,v 1.9 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/

#ifndef MECAB_PARAM_H
#define MECAB_PARAM_H

#include <map>
#include <string>
#include <vector>
#include "common.h"

namespace MeCab {

  struct Option {
    const char *name;
    char        short_name;
    const char *default_value;
    const char *arg_description;
    const char *description;
  };

  class Param {
  private:
    std::map    <std::string, std::string> conf_;
    std::vector <std::string> rest_;
    std::string systemName_;
    std::string help_;
    std::string version_;
    whatlog what_;

  public:
    bool open(int,  char**, const Option *);
    bool open(const char*,  const Option *);
    bool load(const char*);
    void clear();
    const std::vector <std::string>& rest_args() const { return rest_; };

    const char* program_name() const { return systemName_.c_str(); };
    const char *what() { return what_.str(); };

    const char* help(const Option *);
    const char* version(const Option *);
    int help_version(const Option *);

    const std::string getProfileString(const char*);
    int getProfileInt(const char*);
    double getProfileFloat(const char*);
    void setProfile(const char*, const char* value, bool = true);
    void setProfile(const char*, int, bool = true);

    explicit Param() {};
    virtual ~Param() {};
  };
}

#endif
