dnl
dnl AM_PATH_MATH3D([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
AC_DEFUN(AM_PATH_MATH3D,
[

AC_ARG_WITH(math3d-prefix,[  --with-math3d-prefix=PFX   Prefix where Math3d is installed (optional)],
            math3d_config_prefix="$withval", math3d_config_prefix="")
AC_ARG_WITH(math3d-exec-prefix,[  --with-math3d-exec-prefix=PFX  Exec prefix where Math3d is installed (optional)],
            math3d_config_exec_prefix="$withval", math3d_config_exec_prefix="")

  if test x$math3d_config_exec_prefix != x ; then
     math3d_config_args="$math3d_config_args --exec-prefix=$math3d_config_exec_prefix"
     if test x${MATH3D_CONFIG+set} != xset ; then
        MATH3D_CONFIG=$math3d_config_exec_prefix/bin/math3d-config
     fi
  fi
  if test x$math3d_config_prefix != x ; then
     math3d_config_args="$math3d_config_args --prefix=$math3d_config_prefix"
     if test x${MATH3D_CONFIG+set} != xset ; then
        MATH3D_CONFIG=$math3d_config_prefix/bin/math3d-config
     fi
  fi

  AC_PATH_PROG(MATH3D_CONFIG, math3d-config, no)
  math3d_version_min=$1

  AC_MSG_CHECKING(for Math3d - version >= $math3d_version_min)
  no_math3d=""
  if test "$MATH3D_CONFIG" = "no" ; then
    no_math3d=yes
  else
    MATH3D_CFLAGS=`$MATH3D_CONFIG --cflags`
    MATH3D_LIBS=`$MATH3D_CONFIG --libs`
    math3d_version=`$MATH3D_CONFIG --version`

    math3d_major_version=`echo $math3d_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    math3d_minor_version=`echo $math3d_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    math3d_micro_version=`echo $math3d_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    math3d_major_min=`echo $math3d_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    math3d_minor_min=`echo $math3d_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    math3d_micro_min=`echo $math3d_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    math3d_version_proper=`expr \
        $math3d_major_version \> $math3d_major_min \| \
        $math3d_major_version \= $math3d_major_min \& \
        $math3d_minor_version \> $math3d_minor_min \| \
        $math3d_major_version \= $math3d_major_min \& \
        $math3d_minor_version \= $math3d_minor_min \& \
        $math3d_micro_version \>= $math3d_micro_min `

    if test "$math3d_version_proper" = "1" ; then
      AC_MSG_RESULT([$math3d_major_version.$math3d_minor_version.$math3d_micro_version])
    else
      AC_MSG_RESULT(no)
      no_math3d=yes
    fi
  fi

  if test "x$no_math3d" = x ; then
     ifelse([$2], , :, [$2])     
  else
     MATH3D_CFLAGS=""
     MATH3D_LIBS=""
     ifelse([$3], , :, [$3])
  fi

  AC_SUBST(MATH3D_CFLAGS)
  AC_SUBST(MATH3D_LIBS)
])



