/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.dita.dost.module.Content;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DitaIndexWriter
extends AbstractWriter
implements ContentHandler,
LexicalHandler {
    private String indexEntries;
    private XMLReader reader;
    private OutputStreamWriter output;
    private boolean hasProlog;
    private boolean hasMetadata;
    private boolean needResolveEntity;

    public void setContent(Content content) {
        this.indexEntries = (String)content.getObject();
    }

    public DitaIndexWriter() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(String filename) {
        try {
            this.needResolveEntity = true;
            this.hasProlog = false;
            this.hasMetadata = false;
            File inputFile = new File(filename);
            File outputFile = new File(filename + ".temp");
            FileOutputStream fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.parse(filename);
            this.output.close();
            if (!inputFile.delete()) {
                System.out.println("File not deleted. " + inputFile.getPath());
            }
            if (!outputFile.renameTo(inputFile)) {
                System.out.println("File not renamed. " + outputFile.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        block2: {
            if (!this.needResolveEntity) break block2;
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!this.hasMetadata && qName.equals("prolog")) {
                this.output.write("<metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata>");
                this.hasMetadata = true;
            }
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?>");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            this.output.write(name);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (!this.hasProlog && atts.getValue("class").indexOf("topic/body") != -1) {
                this.output.write("<prolog class=\"- topic/prolog \"><metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata></prolog>");
            }
            if (this.hasProlog && !this.hasMetadata && qName.equals("resourceid")) {
                this.output.write("<metadata class=\"- topic/metadata \">");
                this.output.write(this.indexEntries);
                this.output.write("</metadata>");
                this.hasMetadata = true;
            }
            this.output.write("<" + qName);
            int i = 0;
            while (i < atts.getLength()) {
                String attQName = atts.getQName(i);
                String attValue = atts.getValue(i);
                this.output.write(" " + attQName + "=\"" + attValue + "\"");
                ++i;
            }
            this.output.write(">");
            if (atts.getValue("class").indexOf(" topic/metadata ") != -1) {
                this.hasMetadata = true;
                this.output.write(this.indexEntries);
            }
            if (atts.getValue("class").indexOf(" topic/prolog ") != -1) {
                this.hasProlog = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public void startCDATA() throws SAXException {
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

