/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.trax;

import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.OutputStreamDestination;
import com.jclark.xsl.sax2.OutputMethodHandlerImpl;
import com.jclark.xsl.sax2.XSLProcessorImpl;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.trax.TransformerFactoryImpl;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class TransformerImpl
extends Transformer {
    private URIResolver _uriResolver;
    private ErrorListener _errorListener;
    private XSLProcessorImpl _processor;
    private Sheet _sheet;
    private TransformerFactoryImpl _factory;

    public TransformerImpl(Sheet sheet, Engine engine, TransformerFactoryImpl factory) {
        this._sheet = sheet;
        this._processor = new XSLProcessorImpl(sheet, engine);
        this._factory = factory;
    }

    protected XSLProcessorImpl init(Result result) throws TransformerException {
        XSLProcessorImpl processor = (XSLProcessorImpl)this._processor.clone();
        if (result instanceof StreamResult) {
            StreamResult sr = (StreamResult)result;
            OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl();
            processor.setOutputMethodHandler(outputMethodHandler);
            OutputStream ostream = sr.getOutputStream();
            if (ostream == null) {
                throw new TransformerException("cannot use Writer result");
            }
            OutputStreamDestination dest = new OutputStreamDestination(ostream);
            outputMethodHandler.setDestination(dest);
        } else if (result instanceof SAXResult) {
            SAXResult sr = (SAXResult)result;
            processor.setContentHandler(sr.getHandler());
        } else {
            throw new TransformerException("unrecognized Result class: " + result.getClass().getName());
        }
        return processor;
    }

    public void transform(Source source, Result result) throws TransformerException {
        XSLProcessorImpl processor = this.init(result);
        try {
            XMLReader reader = this._factory.getReader(source);
            processor.setSourceReader(reader);
            String sysId = source.getSystemId();
            InputSource src = SAXSource.sourceToInputSource(source);
            if (src == null) {
                src = sysId == null ? new InputSource("dummy") : new InputSource(sysId);
            }
            processor.parse(src);
        }
        catch (Exception ex) {
            throw new TransformerException(ex);
        }
    }

    public void clearParameters() {
        this._processor.clearParameters();
    }

    public void setParameter(String name, Object value) {
        this._processor.setParameter(name, value);
    }

    public Object getParameter(String name) {
        return this._processor.getParameter(name);
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (oformat == null) {
            this._sheet.clearOutputMethodProperties();
        } else {
            Enumeration<Object> keys = oformat.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String val = oformat.getProperty(key);
                this.setOutputProperty(key, val);
            }
        }
    }

    public Properties getOutputProperties() {
        return this._sheet.getOutputMethodProperties();
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        try {
            this._sheet.setOutputMethodProperty("", name, value);
        }
        catch (XSLException ex) {
            throw new IllegalArgumentException(name + " = " + value);
        }
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this._sheet.getOutputMethodProperty("", name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this._errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }
}

