/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.tr.OutputMethod;
import java.util.Properties;

class OutputMethodProperties
extends Properties {
    private final OutputMethod _method;
    private final Name[] _names;
    private Name[] _cdataSectionElements;

    OutputMethodProperties(OutputMethod method) {
        this._method = method;
        this._names = method.getAttributeNames();
        this._cdataSectionElements = method.getCdataSectionElements();
        if (this._cdataSectionElements.length == 0) {
            this._cdataSectionElements = null;
        }
    }

    public String getProperty(String nameString) {
        if (nameString.equals("cdata-section-elements")) {
            return this._cdataSectionElements == null ? null : this.getValue(0);
        }
        int ns = nameString.lastIndexOf(94);
        Name name = ns < 0 ? this.toName("", nameString) : this.toName(nameString.substring(0, ns), nameString.substring(ns + 1));
        return this._method.getSpecifiedValue(name);
    }

    private static final String nameToString(Name name) {
        if (name.getNamespace() == null) {
            return name.getLocalPart();
        }
        return name.getNamespace() + '^' + name.getLocalPart();
    }

    private String getValue(int i) {
        if (this._cdataSectionElements != null && i-- == 0) {
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < this._cdataSectionElements.length; ++i) {
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(OutputMethodProperties.nameToString(this._cdataSectionElements[i]));
            }
            return buf.toString();
        }
        return this._method.getSpecifiedValue(this._names[i]);
    }

    private Name toName(String namespaceURI, String localPart) {
        Name name = namespaceURI == null || namespaceURI.length() == 0 ? this._method.getNameTable().createName(localPart) : this._method.getNameTable().createName(namespaceURI, localPart);
        return name;
    }
}

