/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.tr.OutputMethod;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class OutputMethodDefaulter
implements DocumentHandler,
CommentHandler,
RawCharactersHandler {
    private final ResultBase result;
    private final OutputMethod outputMethod;
    private final Vector savedEvents = new Vector();
    private Locator locator;

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
        this.getDocumentHandler(false).endDocument();
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.getDocumentHandler(name.equalsIgnoreCase("html") && atts.getValue("xmlns") == null).startElement(name, atts);
    }

    public void endElement(String name) {
        throw new Error("unbalanced call to endElement");
    }

    public void characters(char[] buf, int off, int len) throws SAXException {
        block3: for (int i = 0; i < len; ++i) {
            switch (buf[off + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.getDocumentHandler(false).characters(buf, off, len);
                    return;
                }
            }
        }
        this.savedEvents.addElement(new CharactersEvent(buf, off, len));
    }

    public void ignorableWhitespace(char[] buf, int off, int len) throws SAXException {
        this.savedEvents.addElement(new IgnorableWhitespaceEvent(buf, off, len));
    }

    public void comment(String content) {
        this.savedEvents.addElement(new CommentEvent(content));
    }

    public void processingInstruction(String target, String content) {
        this.savedEvents.addElement(new ProcessingInstructionEvent(target, content));
    }

    public void rawCharacters(String chars) {
        this.savedEvents.addElement(new RawCharactersEvent(chars));
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    OutputMethodDefaulter(ResultBase result, OutputMethod outputMethod) {
        this.result = result;
        this.outputMethod = outputMethod;
    }

    private DocumentHandler getDocumentHandler(boolean isHtml) throws SAXException {
        Name name = this.outputMethod.getNameTable().createName(isHtml ? "html" : "xml");
        try {
            DocumentHandler handler = this.result.setOutputMethod(name, this.outputMethod);
            if (this.locator != null) {
                handler.setDocumentLocator(this.locator);
            }
            handler.startDocument();
            Enumeration iter = this.savedEvents.elements();
            while (iter.hasMoreElements()) {
                ((Event)iter.nextElement()).emit(handler);
            }
            return handler;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    static class IgnorableWhitespaceEvent
    extends Event {
        private char[] buf;

        IgnorableWhitespaceEvent(char[] b, int off, int len) {
            this.buf = new char[len];
            System.arraycopy(b, off, this.buf, 0, len);
        }

        void emit(DocumentHandler handler) throws SAXException {
            handler.ignorableWhitespace(this.buf, 0, this.buf.length);
        }
    }

    static class CharactersEvent
    extends Event {
        private char[] buf;

        CharactersEvent(char[] b, int off, int len) {
            this.buf = new char[len];
            System.arraycopy(b, off, this.buf, 0, len);
        }

        void emit(DocumentHandler handler) throws SAXException {
            handler.characters(this.buf, 0, this.buf.length);
        }
    }

    static class RawCharactersEvent
    extends Event {
        private String chars;

        RawCharactersEvent(String chars) {
            this.chars = chars;
        }

        void emit(DocumentHandler handler) throws SAXException {
            if (handler instanceof RawCharactersHandler) {
                ((RawCharactersHandler)((Object)handler)).rawCharacters(this.chars);
            } else {
                char[] buf = this.chars.toCharArray();
                handler.characters(buf, 0, buf.length);
            }
        }
    }

    static class CommentEvent
    extends Event {
        private String content;

        CommentEvent(String content) {
            this.content = content;
        }

        void emit(DocumentHandler handler) throws SAXException {
            if (handler instanceof CommentHandler) {
                ((CommentHandler)((Object)handler)).comment(this.content);
            }
        }
    }

    static class ProcessingInstructionEvent
    extends Event {
        private String target;
        private String content;

        ProcessingInstructionEvent(String target, String content) {
            this.target = target;
            this.content = content;
        }

        void emit(DocumentHandler handler) throws SAXException {
            handler.processingInstruction(this.target, this.content);
        }
    }

    static abstract class Event {
        Event() {
        }

        abstract void emit(DocumentHandler var1) throws SAXException;
    }
}

