/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ArrayNodeIterator;
import com.jclark.xsl.expr.DescendantAxisExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.NodeTestExpr;
import com.jclark.xsl.expr.NullNodeIterator;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;
import java.util.Hashtable;

public class KeyValuesTable {
    private String _keyName;
    private Hashtable _table = new Hashtable();

    public KeyValuesTable(Pattern pattern, StringExpr valueExpr, Node n, ExprContext context) {
        try {
            this.indexDoc(pattern, valueExpr, n, context);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public NodeIterator get(String keyValue) {
        NodeArray na = (NodeArray)this._table.get(keyValue);
        if (na == null) {
            return new NullNodeIterator();
        }
        return na.getIterator();
    }

    private void indexDoc(Pattern pattern, StringExpr valueExpr, Node n, ExprContext context) throws XSLException {
        NodeTestExpr nte = new NodeTestExpr(new DescendantAxisExpr(), pattern);
        NodeIterator matchNodesIter = nte.eval(n.getRoot(), context);
        Node matched = matchNodesIter.next();
        while (matched != null) {
            String key = valueExpr.eval(matched, context);
            NodeArray list = (NodeArray)this._table.get(key);
            if (list == null) {
                list = new NodeArray(matched);
                this._table.put(key, list);
            } else {
                list.add(matched);
            }
            matched = matchNodesIter.next();
        }
    }

    private class NodeArray {
        Node[] nodes = new Node[1];
        int off = 0;

        NodeArray(Node n) {
            this.nodes[0] = n;
        }

        void add(Node n) {
            if (this.off == 0) {
                Node[] oldNodes = this.nodes;
                this.nodes = new Node[oldNodes.length * 2];
                System.arraycopy(oldNodes, 0, this.nodes, oldNodes.length, oldNodes.length);
                this.off = oldNodes.length;
            }
            this.nodes[--this.off] = n;
        }

        NodeIterator getIterator() {
            return new ArrayNodeIterator(this.nodes, this.off, this.nodes.length);
        }
    }
}

