/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.conv;

import com.jclark.xsl.conv.AlphabetFormatTokenHandler;
import com.jclark.xsl.conv.AlphabetNumberFormat;
import com.jclark.xsl.conv.DecimalNumberFormat;
import com.jclark.xsl.conv.FormatTokenHandler;
import com.jclark.xsl.conv.NumberFormat;
import com.jclark.xsl.conv.RomanNumberFormat;
import java.util.Hashtable;

public class NumberListFormat
implements Cloneable {
    private static NumberFormat defaultFormat = new DecimalNumberFormat('0', 1);
    private static Hashtable formatTokenHandlerTable = new Hashtable();
    private NumberFormat[] formats = null;
    private String[] formatTokens = new String[]{"1"};
    private String prefix = "";
    private String suffix = "";
    private String[] separators = new String[]{"."};
    private int groupingSize = 0;
    private String groupingSeparator = null;
    private String lang = null;
    private String letterValue = null;

    public static void setFormatTokenHandler(String formatToken, FormatTokenHandler handler) {
        formatTokenHandlerTable.put(formatToken, handler);
    }

    public void setFormat(String format) {
        this.formats = null;
        int n = 0;
        for (int i = 0; i < format.length(); ++i) {
            if (!NumberListFormat.isAlnum(format.charAt(i)) || i != 0 && NumberListFormat.isAlnum(format.charAt(i - 1))) continue;
            ++n;
        }
        if (n == 0) {
            this.formatTokens = new String[1];
            this.formatTokens[0] = "1";
            this.prefix = "";
        } else {
            this.formatTokens = new String[n];
        }
        if (n <= 1) {
            this.separators = new String[1];
            this.separators[0] = ".";
        } else {
            this.separators = new String[n - 1];
        }
        int fi = 0;
        for (int i = 0; i < n; ++i) {
            int sepStart = fi;
            while (!NumberListFormat.isAlnum(format.charAt(fi))) {
                ++fi;
            }
            if (i == 0) {
                this.prefix = format.substring(0, fi);
            } else {
                this.separators[i - 1] = format.substring(sepStart, fi);
            }
            int numberStart = fi++;
            while (fi < format.length() && NumberListFormat.isAlnum(format.charAt(fi))) {
                ++fi;
            }
            this.formatTokens[i] = format.substring(numberStart, fi);
        }
        this.suffix = format.substring(fi);
    }

    private static boolean isAlnum(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public void setLang(String lang) {
        this.formats = null;
        this.lang = lang;
    }

    public void setLetterValue(String letterValue) {
        this.letterValue = letterValue;
    }

    public void setGroupingSeparator(String sep) {
        this.groupingSeparator = sep == null || sep.length() == 0 ? null : sep;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = n;
    }

    public String getPrefix(int i) {
        if (i == 0) {
            return this.prefix;
        }
        if (--i < this.separators.length) {
            return this.separators[i];
        }
        return this.separators[this.separators.length - 1];
    }

    public String formatNumber(int i, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("cannot format negative number");
        }
        return this.group(this.getFormat(i).format(n));
    }

    public String getSuffix() {
        return this.suffix;
    }

    private NumberFormat getFormat(int i) {
        if (this.formats == null) {
            this.formats = new NumberFormat[this.formatTokens.length];
        }
        if (i >= this.formats.length) {
            i = this.formats.length - 1;
        }
        if (this.formats[i] == null) {
            this.formats[i] = this.findFormat(this.formatTokens[i]);
        }
        return this.formats[i];
    }

    private NumberFormat findFormat(String formatToken) {
        NumberFormat f = this.findDecimalFormat(formatToken);
        if (f != null) {
            return f;
        }
        FormatTokenHandler handler = (FormatTokenHandler)formatTokenHandlerTable.get(formatToken);
        if (handler != null && (f = handler.getFormat(this.lang, this.letterValue)) != null) {
            return f;
        }
        return defaultFormat;
    }

    private NumberFormat findDecimalFormat(String format) {
        char digitOne = format.charAt(format.length() - 1);
        if (!Character.isDigit(digitOne) || Character.digit(digitOne, 10) != 1) {
            return null;
        }
        for (int i = 0; i < format.length() - 1; ++i) {
            if (format.charAt(i) + '\u0001' == digitOne) continue;
            return null;
        }
        return new DecimalNumberFormat((char)(digitOne - '\u0001'), format.length());
    }

    private String group(String number) {
        if (this.groupingSeparator == null || this.groupingSize <= 0 || number.length() <= this.groupingSize) {
            return number;
        }
        char[] buf = new char[number.length() + (number.length() - 1) / this.groupingSize * this.groupingSeparator.length()];
        int j = 0;
        for (int i = 0; i < number.length(); ++i) {
            if (i > 0 && (number.length() - i) % this.groupingSize == 0) {
                for (int k = 0; k < this.groupingSeparator.length(); ++k) {
                    buf[j++] = this.groupingSeparator.charAt(k);
                }
            }
            buf[j++] = number.charAt(i);
        }
        return new String(buf);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    static {
        AlphabetNumberFormat format = new AlphabetNumberFormat("abcdefghijklmnopqrstuvwxyz");
        AlphabetFormatTokenHandler handler = new AlphabetFormatTokenHandler(format);
        formatTokenHandlerTable.put("a", handler);
        format = new AlphabetNumberFormat("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        handler = new AlphabetFormatTokenHandler(format);
        formatTokenHandlerTable.put("A", handler);
        formatTokenHandlerTable.put("i", new RomanNumberFormat("mdclxvi"));
        formatTokenHandlerTable.put("I", new RomanNumberFormat("MDCLXVI"));
    }
}

