/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.taskdefs.optional.extension.Compatibility;
import org.apache.tools.ant.taskdefs.optional.extension.DeweyDecimal;

public final class Specification {
    public static final Attributes.Name SPECIFICATION_TITLE = Attributes.Name.SPECIFICATION_TITLE;
    public static final Attributes.Name SPECIFICATION_VERSION = Attributes.Name.SPECIFICATION_VERSION;
    public static final Attributes.Name SPECIFICATION_VENDOR = Attributes.Name.SPECIFICATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_TITLE = Attributes.Name.IMPLEMENTATION_TITLE;
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VENDOR = Attributes.Name.IMPLEMENTATION_VENDOR;
    public static final Compatibility COMPATIBLE = new Compatibility("COMPATIBLE");
    public static final Compatibility REQUIRE_SPECIFICATION_UPGRADE = new Compatibility("REQUIRE_SPECIFICATION_UPGRADE");
    public static final Compatibility REQUIRE_VENDOR_SWITCH = new Compatibility("REQUIRE_VENDOR_SWITCH");
    public static final Compatibility REQUIRE_IMPLEMENTATION_CHANGE = new Compatibility("REQUIRE_IMPLEMENTATION_CHANGE");
    public static final Compatibility INCOMPATIBLE = new Compatibility("INCOMPATIBLE");
    private String m_specificationTitle;
    private DeweyDecimal m_specificationVersion;
    private String m_specificationVendor;
    private String m_implementationTitle;
    private String m_implementationVendor;
    private String m_implementationVersion;
    private String[] m_sections;

    public static Specification[] getSpecifications(Manifest manifest) throws ParseException {
        if (null == manifest) {
            return new Specification[0];
        }
        ArrayList<Specification> results = new ArrayList<Specification>();
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            Attributes attributes;
            String key = keys.next();
            Specification specification = Specification.getSpecification(key, attributes = entries.get(key));
            if (null == specification) continue;
            results.add(specification);
        }
        ArrayList trimmedResults = Specification.removeDuplicates(results);
        return trimmedResults.toArray(new Specification[0]);
    }

    public Specification(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor) {
        this(specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, null);
    }

    public Specification(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, String[] sections) {
        this.m_specificationTitle = specificationTitle;
        this.m_specificationVendor = specificationVendor;
        if (null != specificationVersion) {
            try {
                this.m_specificationVersion = new DeweyDecimal(specificationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad specification version format '" + specificationVersion + "' in '" + specificationTitle + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        this.m_implementationTitle = implementationTitle;
        this.m_implementationVendor = implementationVendor;
        this.m_implementationVersion = implementationVersion;
        if (null == this.m_specificationTitle) {
            throw new NullPointerException("specificationTitle");
        }
        String[] copy = null;
        if (null != sections) {
            copy = new String[sections.length];
            System.arraycopy(sections, 0, copy, 0, sections.length);
        }
        this.m_sections = copy;
    }

    public String getSpecificationTitle() {
        return this.m_specificationTitle;
    }

    public String getSpecificationVendor() {
        return this.m_specificationVendor;
    }

    public String getImplementationTitle() {
        return this.m_implementationTitle;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.m_specificationVersion;
    }

    public String getImplementationVendor() {
        return this.m_implementationVendor;
    }

    public String getImplementationVersion() {
        return this.m_implementationVersion;
    }

    public String[] getSections() {
        if (null == this.m_sections) {
            return null;
        }
        String[] sections = new String[this.m_sections.length];
        System.arraycopy(this.m_sections, 0, sections, 0, this.m_sections.length);
        return sections;
    }

    public Compatibility getCompatibilityWith(Specification other) {
        if (!this.m_specificationTitle.equals(other.getSpecificationTitle())) {
            return INCOMPATIBLE;
        }
        DeweyDecimal specificationVersion = other.getSpecificationVersion();
        if (!(null == specificationVersion || null != this.m_specificationVersion && this.isCompatible(this.m_specificationVersion, specificationVersion))) {
            return REQUIRE_SPECIFICATION_UPGRADE;
        }
        String implementationVendor = other.getImplementationVendor();
        if (!(null == implementationVendor || null != this.m_implementationVendor && this.m_implementationVendor.equals(implementationVendor))) {
            return REQUIRE_VENDOR_SWITCH;
        }
        String implementationVersion = other.getImplementationVersion();
        if (!(null == implementationVersion || null != this.m_implementationVersion && this.m_implementationVersion.equals(implementationVersion))) {
            return REQUIRE_IMPLEMENTATION_CHANGE;
        }
        return COMPATIBLE;
    }

    public boolean isCompatibleWith(Specification other) {
        return COMPATIBLE == this.getCompatibilityWith(other);
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(SPECIFICATION_TITLE.toString());
        sb.append(": ");
        sb.append(this.m_specificationTitle);
        sb.append(lineSeparator);
        if (null != this.m_specificationVersion) {
            sb.append(SPECIFICATION_VERSION);
            sb.append(": ");
            sb.append(this.m_specificationVersion);
            sb.append(lineSeparator);
        }
        if (null != this.m_specificationVendor) {
            sb.append(SPECIFICATION_VENDOR);
            sb.append(": ");
            sb.append(this.m_specificationVendor);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationTitle) {
            sb.append(IMPLEMENTATION_TITLE);
            sb.append(": ");
            sb.append(this.m_implementationTitle);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationVersion) {
            sb.append(IMPLEMENTATION_VERSION);
            sb.append(": ");
            sb.append(this.m_implementationVersion);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationVendor) {
            sb.append(IMPLEMENTATION_VENDOR);
            sb.append(": ");
            sb.append(this.m_implementationVendor);
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private boolean isCompatible(DeweyDecimal first, DeweyDecimal second) {
        return first.isGreaterThanOrEqual(second);
    }

    private static ArrayList removeDuplicates(ArrayList list) {
        ArrayList<Specification> results = new ArrayList<Specification>();
        ArrayList<String> sections = new ArrayList<String>();
        while (list.size() > 0) {
            Specification specification = (Specification)list.remove(0);
            Iterator iterator = ((AbstractList)list).iterator();
            while (iterator.hasNext()) {
                Specification other = (Specification)iterator.next();
                if (!Specification.isEqual(specification, other)) continue;
                String[] otherSections = other.getSections();
                if (null != sections) {
                    sections.addAll(Arrays.asList(otherSections));
                }
                iterator.remove();
            }
            Specification merged = Specification.mergeInSections(specification, sections);
            results.add(merged);
            sections.clear();
        }
        return results;
    }

    private static boolean isEqual(Specification specification, Specification other) {
        return specification.getSpecificationTitle().equals(other.getSpecificationTitle()) && specification.getSpecificationVersion().isEqual(other.getSpecificationVersion()) && specification.getSpecificationVendor().equals(other.getSpecificationVendor()) && specification.getImplementationTitle().equals(other.getImplementationTitle()) && specification.getImplementationVersion().equals(other.getImplementationVersion()) && specification.getImplementationVendor().equals(other.getImplementationVendor());
    }

    private static Specification mergeInSections(Specification specification, ArrayList sectionsToAdd) {
        if (0 == sectionsToAdd.size()) {
            return specification;
        }
        sectionsToAdd.addAll(Arrays.asList(specification.getSections()));
        String[] sections = sectionsToAdd.toArray(new String[sectionsToAdd.size()]);
        return new Specification(specification.getSpecificationTitle(), specification.getSpecificationVersion().toString(), specification.getSpecificationVendor(), specification.getImplementationTitle(), specification.getImplementationVersion(), specification.getImplementationVendor(), sections);
    }

    private static String getTrimmedString(String value) {
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    private static Specification getSpecification(String section, Attributes attributes) throws ParseException {
        String name = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_TITLE));
        if (null == name) {
            return null;
        }
        String specVendor = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_VENDOR));
        if (null == specVendor) {
            throw new ParseException("Missing " + SPECIFICATION_VENDOR, 0);
        }
        String specVersion = Specification.getTrimmedString(attributes.getValue(SPECIFICATION_VERSION));
        if (null == specVersion) {
            throw new ParseException("Missing " + SPECIFICATION_VERSION, 0);
        }
        String impTitle = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_TITLE));
        if (null == impTitle) {
            throw new ParseException("Missing " + IMPLEMENTATION_TITLE, 0);
        }
        String impVersion = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_VERSION));
        if (null == impVersion) {
            throw new ParseException("Missing " + IMPLEMENTATION_VERSION, 0);
        }
        String impVendor = Specification.getTrimmedString(attributes.getValue(IMPLEMENTATION_VENDOR));
        if (null == impVendor) {
            throw new ParseException("Missing " + IMPLEMENTATION_VENDOR, 0);
        }
        return new Specification(name, specVersion, specVendor, impTitle, impVersion, impVendor, new String[]{section});
    }
}

