package com.jclark.xsl.sax;

import org.xml.sax.*;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.File;
import java.io.FileDescriptor;
import java.net.URL;

public class XmlToHtml {
  static class EmptyAttributeList implements AttributeList {
    public int getLength() { return 0; }
    public String getName(int i) {
      return null;
    }
    public String getType(int i) {
      return null;
    }
    public String getValue(int i) {
      return null;
    }
    public String getValue(String name) {
      return null;
    }
    public String getType(String name) {
      return null;
    }
  }

  static class SingleAttributeList implements AttributeList {
    String name;
    String value;
    SingleAttributeList(String name, String value) {
      this.name = name;
      this.value = value;
    }

    public int getLength() { return 0; }
    public String getName(int i) {
      if (i == 0)
	return name;
      return null;
    }
    public String getType(int i) {
      if (i == 0)
	return "CDATA";
      return null;
    }
    public String getValue(int i) {
      if (i == 0)
	return value;
      return null;
    }
    public String getValue(String name) {
      if (name.equals(this.name))
	return value;
      return null;
    }
    public String getType(String name) {
      if (name.equals(this.name))
	return "CDATA";
      return null;
    }
  }

  public static void main(String[] args) throws IOException {
    if (args.length != 2) {
      System.err.println("xmltohtml xml html");
      System.exit(1);
    }
    Parser parser = createParser();
    HTMLOutputHandler handler = new HTMLOutputHandler();
    handler.init(new FileDestination(args[1]), new SingleAttributeList("encoding", "iso-8859-1"));
    parser.setDocumentHandler(handler);
    try {
      parser.parse(fileInputSource(args[0]));
    }
    catch (SAXException e) {
      System.err.println(e.getMessage());
      System.exit(1);
    }
  }

  static Parser createParser() {
    String parserClass = System.getProperty("com.jclark.xsl.sax.parser");
    if (parserClass == null)
      parserClass = System.getProperty("org.xml.sax.parser");
    if (parserClass == null)
      parserClass = "com.jclark.xml.sax.CommentDriver";
    try {
      return (Parser)Class.forName(parserClass).newInstance();
    }
    catch (ClassNotFoundException e) {
      System.err.println(e.toString());
    }
    catch (InstantiationException e) {
      System.err.println(e.toString());
    }
    catch (IllegalAccessException e) {
      System.err.println(e.toString());
    }
    catch (ClassCastException e) {
      System.err.println(parserClass + " is not a SAX driver");
    }
    return null;
  }

  /**
   * Generates an <code>InputSource</code> from a file name.
   */
  static public InputSource fileInputSource(String str) {
    return fileInputSource(new File(str));
  }

  static public InputSource fileInputSource(File file) {
    String path = file.getAbsolutePath();
    String fSep = System.getProperty("file.separator");
    if (fSep != null && fSep.length() == 1)
      path = path.replace(fSep.charAt(0), '/');
    if (path.length() > 0 && path.charAt(0) != '/')
      path = '/' + path;
    try {
      return new InputSource(new URL("file", "", path).toString());
    }
    catch (java.net.MalformedURLException e) {
      /* According to the spec this could only happen if the file
	 protocol were not recognized. */
      throw new Error("unexpected MalformedURLException");
    }
  }

}
