package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class SubtractExpr extends ConvertibleNumberExpr {
  private final NumberExpr expr1;
  private final NumberExpr expr2;

  SubtractExpr(NumberExpr expr1, NumberExpr expr2) {
    this.expr1 = expr1;
    this.expr2 = expr2;
  }

  public double eval(Node node, ExprContext context) throws XSLException {
    return expr1.eval(node, context) - expr2.eval(node, context);
  }
}
