package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ParentPattern extends PathPatternBase {
  private PathPatternBase childPattern;
  private Pattern parentPattern;

  ParentPattern(PathPatternBase childPattern, Pattern parentPattern) {
    this.childPattern = childPattern;
    this.parentPattern = parentPattern;
  }

  public boolean matches(Node node, ExprContext context) throws XSLException {
    if (!childPattern.matches(node, context))
      return false;
    node = node.getParent();
    if (node == null)
      return false;
    return parentPattern.matches(node, context);
  }

  public int getDefaultPriority() {
    return 1;
  }

  Name getMatchName() {
    return childPattern.getMatchName();
  }

  byte getMatchNodeType() {
    return childPattern.getMatchNodeType();
  }
}
