#
# address.rb
#
#   Copyright (c) 1998-2001 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#

module TMail

  class Address

    def initialize( local, domain )
      @local = local
      @domain = domain
      @phrase = nil
      @routes = []
    end

    attr_reader :phrase
    attr_writer :phrase   # internal use only

    attr_reader :routes
    alias route routes    # obsolete

    def inspect
      "#<#{type} #{address}>"
    end

    def Address.join( arr )
      arr.collect {|i| ::TMail.quote i }.join('.')
    end

    def local
      @local.collect {|i| ::TMail.quote i }.join('.')
    end

    def domain
      if @domain then
        @domain.collect {|i| ::TMail.quote i }.join('.')
      else
        nil
      end
    end

    def spec
      s = local()
      if d = domain() then
        s << '@' << d
      end
      s
    end

    #def spec=( str )
    #  tmp = str.split( '@', 2 )
    #  @local  = tmp[0].split('.')
    #  @domain = tmp[1].split('.')
    #end

    alias address  spec
    #alias address= spec=
    alias addr     spec
    #alias addr=    spec=


    def ==( other )
      #other.respond_to? :routes  and  route()  == other.routes  and
      #other.respond_to? :phrase  and  phrase() == other.phrase  and
      other.respond_to? :spec    and  spec()   == other.spec
    end

    alias eql? ==

    def hash
      @local.hash ^ @domain.hash
    end

    def dup
      obj = type.new( @local.dup, @domain.dup )
      obj.phrase = @phrase.dup if @phrase
      obj.routes.replace @routes
      obj
    end


    include StrategyInterface

    def accept( strategy, dummy = nil )
      spec_p = (not @phrase and @routes.empty?)

      if @phrase then
        strategy.phrase @phrase
        strategy.space
      end
      tmp = spec_p ? '' : '<'
      unless @routes.empty? then
        tmp << @routes.collect {|i| '@' + i }.join(',') << ':'
      end
      tmp << address
      tmp << '>' unless spec_p
      strategy.meta tmp
      strategy.lwsp ''
    end

  end



  class AddressGroup

    include Enumerable

    def initialize( name, addrs )
      @name = name
      @addresses = addrs
    end

    attr_reader :name
    
    def ==( other )
      # other.respond_to? :name      and @name      == other.name       and
      other.respond_to? :addresses and @addresses == other.addresses
    end

    alias eql? ==

    def hash
      collect {|i| i.hash }.hash
    end

    def each( &block )
      @addresses.each( &block )
    end

    def to_a
      @addresses.dup
    end

    alias to_ary to_a

    def flatten
      set = []
      @addresses.each do |a|
        if a.respond_to? :flatten then
          set.concat a.flatten
        else
          set.push a
        end
      end
      set
    end

    def each_address( &block )
      flatten.each( &block )
    end

    def add( a )
      @addresses.push a
    end

    alias push add
    
    def delete( a )
      @addresses.delete a
    end

    include StrategyInterface

    def accept( strategy, dummy = nil )
      strategy.phrase @name
      strategy.meta ':'
      strategy.space
      first = true
      each do |mbox|
        if first then
          first = false
        else
          strategy.meta ','
        end
        strategy.space
        mbox.accept strategy
      end
      strategy.meta ';'
      strategy.lwsp ''
    end

  end

end   # module TMail
