/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.powertoys;

import com.sap.dbtech.util.StructuredMem;
/**
 * Exception thrown when Loader command fails
 */
public class LoaderException extends Exception
{
    private int errorCode;
    /**
     * creates a new LoaderException.
     */
    LoaderException (int eCode, String msg)
    {
        super (msg);
        this.errorCode = eCode;
    }
    
    /**
     * returns the error code as set by dbm server.
     */
    public int getErrorCode ()
    {
        return this.errorCode;
    }
    /**
     * returns printable String of exception
     */
    public String toString ()
    {
        return "<LoaderException " + this.errorCode + " "
            + this.getMessage () + ">";
    }
    /**
     *
     */
    static LoaderException create (StructuredMem packet)
    {
        int errorCode = 0;
        String errorID = "";
        String message = null;
        String rawString;
        int chunkStart = 0;
        int chunkEnd;
        if(packet.size() < Loader.indicatorLengthC) {
            return new LoaderException(-807, "Invalid size of loader reply message (" + packet.size() + " bytes)");
        }
        rawString = packet.getString (Loader.indicatorLengthC, packet.size () - Loader.indicatorLengthC).trim();
        
        int idx =  rawString.indexOf("\n");
        if(idx != -1) {
            try {
                errorCode = Integer.parseInt(rawString.substring(0, idx));
            } catch(NumberFormatException numberFormatEx) {
                // ignore
            }
            message = rawString.substring(idx+1).trim();
        }
        if(message == null) 
            message=rawString;
        return new LoaderException (errorCode, message);
    }
}

