/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.interceptor;

import java.io.Serializable;
import javax.management.ObjectName;

/**
 * The invocation information carrier.
 *
 * @version $Revision: 1.3 $
 */
public class Invocation implements Serializable
{
   public static final String CLASSLOADER_MBEANSERVER = "MBeanServer";
   public static final String CLASSLOADER_REPOSITORY = "ClassLoaderRepository";
   public static final String CLASSLOADER_LOADER = "Loader";
   public static final String CLASSLOADER_MBEAN = "MBean";

   private String m_classloaderKey;
   private ObjectName m_objectName;
   private String m_methodName;
   private String[] m_signature;
   private Object[] m_arguments;
   private InvocationContext m_context;

   /**
    * Returns the key used to identify the classloader to be used as context classloader
    *
    * @see #setClassLoaderKey
    */
   public String getClassLoaderKey()
   {
      return m_classloaderKey;
   }

   /**
    * Sets the key used to identify the classloader to be used as context classloader
    *
    * @see #getClassLoaderKey
    */
   public void setClassLoaderKey(String key)
   {
      m_classloaderKey = key;
   }

   /**
    * Sets the object name to be used to retrieve the classloader used as context classloader
    *
    * @see #getObjectNameForClassLoader
    */
   public void setObjectNameForClassLoader(ObjectName name)
   {
      m_objectName = name;
   }

   /**
    * Returns the object name to be used to retrieve the classloader used as context classloader
    *
    * @see #setObjectNameForClassLoader
    */
   public ObjectName getObjectNameForClassLoader()
   {
      return m_objectName;
   }

   /**
    * Sets the method name to be invoked on the server-side
    *
    * @see #setSignature
    */
   public void setMethodName(String name)
   {
      m_methodName = name;
   }

   /**
    * Sets the signature of the method to be invoked on the server-side
    *
    * @see #setArguments
    */
   public void setSignature(String[] signature)
   {
      m_signature = signature;
   }

   /**
    * Sets the arguments of the method to be invoked on the server-side
    *
    * @see #setMethodName
    */
   public void setArguments(Object[] args)
   {
      m_arguments = args;
   }

   /**
    * Sets the invocation user-defined information
    *
    * @see #getInvocationContext
    */
   public void setInvocationContext(InvocationContext context)
   {
      m_context = context;
   }

   /**
    * Returns the invocation user-defined information
    *
    * @see #setInvocationContext
    */
   public InvocationContext getInvocationContext()
   {
      return m_context;
   }

   /**
    * Returns the invocation method name
    */
   public String getMethodName()
   {
      return m_methodName;
   }

   /**
    * Returns the invocation method arguments
    */
   public Object[] getArguments()
   {
      return m_arguments;
   }

   /**
    * Returns the invocation method signature
    */
   public String[] getSignature()
   {
      return m_signature;
   }
}
