# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
    $| = 1;
    print "# MDN::ResConf\n";
    print "1..79\n";
    use lib '..';
    require 'eucjp';
}

END {
    print "not ok 1\n" unless $loaded;
}

use MDN::ResConf;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test_id = 2;

######################################################################
#
# configuration test
#
MDN::ResConf->enable(1);

print "# load_file, failure\n";
$conf = MDN::ResConf->new();
$conf->load_file('../common/not-found.conf');
$result = (MDN::ResConf->lasterror() =~ /no such file/);
print $result ? 'ok ' : 'not ok ', $test_id++, "\n";

#####
print "# load_file, mdn.conf\n";
$conf = MDN::ResConf->new();
$result = $conf->load_file('../common/mdn.conf');
print $result ? 'ok ' : 'not ok ', $test_id++, "\n";

#####
print "# set & add\n";
$conf = MDN::ResConf->new();
$result = $conf->set_idn_encoding('RACE')
    && $conf->set_local_encoding($EUC_JP)
    && $conf->set_nameprep_version('nameprep-07')
    && $conf->add_nameprep_map('nameprep-07')
    && $conf->add_nameprep_normalize('nameprep-07')
    && $conf->add_nameprep_prohibit('nameprep-07')
    && $conf->add_nameprep_unassigned('nameprep-07')
    && $conf->add_delimiter_map(0x3002)
    && $conf->add_local_map('jp', 'filemap:../common/jp.map');
print $result ? 'ok ' : 'not ok ', $test_id++, "\n";

#####
print "# unset_idn_encoding\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->set_idn_encoding('RACE');
$result1 = ($conf->local_to_idn('') eq 'bq--gbba');

$conf->unset_idn_encoding();
$result2 = ($conf->local_to_idn('') eq "\xe3\x81\x82");

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_nameprep_version\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->set_idn_encoding('RACE');
$conf->set_nameprep_version('nameprep-07');
$result1 = ($conf->local_to_idn('') eq 'a');

$conf->unset_nameprep_version();
$result2 = ($conf->local_to_idn('') eq 'bq--75aq');

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_delimiter_map\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->set_idn_encoding('RACE');
$conf->add_delimiter_map(0x2606);
$result1 = ($conf->local_to_idn('ab') eq 'a.b');

$conf->unset_delimiter_map();
$result2 = ($conf->local_to_idn('ab') eq 'bq--e37wcbx7mi');

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_local_map\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->set_idn_encoding('RACE');
$conf->add_nameprep_normalize('nameprep-07');
$conf->add_local_map('.', 'filemap:../common/jp.map');
$result1 = ($conf->local_to_idn('ab') eq 'a-b');

$conf->unset_local_map();
$result2 = ($conf->local_to_idn('ab') eq 'bq--el7wcex7mi');

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_nameprep_map\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->add_nameprep_map('nameprep-07');
$result1 = ($conf->nameconv('lmL', 'A') eq 'a');

$conf->unset_nameprep_map();
$result2 = ($conf->nameconv('lmL', 'A') eq 'A');

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_nameprep_normalize\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->add_nameprep_normalize('nameprep-07');
$result1 = ($conf->nameconv('lnL', '') eq 'a');

$conf->unset_nameprep_normalize();
$result2 = ($conf->nameconv('lnL', '') eq '');

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_nameprep_prohibit\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->add_nameprep_prohibit('nameprep-07');
$result1 = (defined($conf->nameconv('lp', '')) == 0);

$conf->unset_nameprep_prohibit();
$result2 = (defined($conf->nameconv('lp', '')) == 1);

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# unset_nameprep_unassigned\n";
$conf = MDN::ResConf->new();
$conf->set_local_encoding($EUC_JP);
$conf->add_nameprep_unassigned('nameprep-07');
# "\xc8\xa0" represents U+0220.
$result1 = (defined($conf->nameconv('u', "\xc8\xa0")) == 0);

$conf->unset_nameprep_unassigned();
$result2 = (defined($conf->nameconv('u', "\xc8\xa0")) == 1);

print(($result1 && $result2) ? 'ok ' : 'not ok ', $test_id++, "\n");

#####
print "# enable\n";
$conf = MDN::ResConf->new();
$conf->load_file('../common/mdn.conf');
MDN::ResConf->enable(0);
$result1 = ($conf->local_to_idn('') eq '');
print(($result1) ? 'ok ' : 'not ok ', $test_id++, "\n");

######################################################################
#
# conversion tests
#
MDN::ResConf->enable(1);

$conf = MDN::ResConf->new();
$result = $conf->load_file('../common/mdn.conf');

if (!open(TESTDATA, '../common/testdata')) {
    die "failed to open the file, $!: ../common/testdata\n";
}

while (<TESTDATA>) {
    chomp;
    next if (/^\#/ || /^$/);
    ($title, $action, $incode, $inname, $expcode, $expname)
	= split(/[ \t]*:[ \t]*/, $_);

    if ($incode eq 'UTF-8') {
	$inname = to_utf8($inname);
    } elsif ($incode eq 'EUC-JP') {
	$inname = to_eucjp($inname);
    }
    if ($expcode eq 'UTF-8') {
	$expname = to_utf8($expname);
    } elsif ($expcode eq 'EUC-JP') {
	$expname = to_eucjp($expname);
    }

    print "# $title (nameconv)\n";
    $outname1 = $conf->nameconv($action, $inname);
    if (!defined($outname1)) {
	($outname1 = MDN::ResConf->lasterror()) =~ s/, .*$//;
    }
    print($outname1 eq $expname ? 'ok ' : 'not ok ', $test_id++, "\n");

    if ($action eq 'l') {
	$outname2 = $conf->local_to_utf8($inname);
    } elsif ($action eq 'L') {
	$outname2 = $conf->utf8_to_local($inname);
    } elsif ($action eq 'd') {
	$outname2 = $conf->delimiter_map($inname);
    } elsif ($action eq 'M') {
	$outname2 = $conf->local_map($inname);
    } elsif ($action eq 'm') {
	$outname2 = $conf->map($inname);
    } elsif ($action eq 'n') {
	$outname2 = $conf->normalize($inname);
    } elsif ($action eq 'p') {
	$outname2 = $conf->prohibit_check($inname);
    } elsif ($action eq 'u') {
	$outname2 = $conf->unassigned_check($inname);
    } elsif ($action eq 'N') {
	$outname2 = $conf->nameprep($inname);
    } elsif ($action eq '!N') {
	$outname2 = $conf->nameprep_check($inname);
    } elsif ($action eq 'I') {
	$outname2 = $conf->utf8_to_idn($inname);
    } elsif ($action eq 'i') {
	$outname2 = $conf->idn_to_utf8($inname);
    } elsif ($action eq 'ldMNI') {
	$outname2 = $conf->local_to_idn($inname);
    } elsif ($action eq 'i!NL') {
	$outname2 = $conf->idn_to_local($inname);
    } else {
	next;
    }

    print "# $title (X_to_Y)\n";
    if (!defined($outname2)) {
	($outname2 = MDN::ResConf->lasterror()) =~ s/, .*$//;
    }
    print($outname2 eq $expname ? 'ok ' : 'not ok ', $test_id++, "\n");
}

close(TESTDATA);

######################################################################
#
# sub routines
#
sub to_utf8 ($) {
    my $result = '';
    my ($offset, $mask, $length);

    foreach my $i (split(/[ \t\n]/, $_[0])) {
	if ($i =~ /^U\+([0-9A-Fa-f]+)$/) {
	    $ucs = hex($1);
	} elsif ($i =~ /^[\x21-\x7e]$/) {
	    $ucs = ord($i);
	} else {
	    die "invalid character, $i\n" 
	}

        if ($ucs < 0x80) {
	    $mask = 0;
	    $length = 1;
        } elsif ($ucs < 0x800) {
	    $mask = 0xc0;
	    $length = 2;
        } elsif ($ucs < 0x10000) {
	    $mask = 0xe0;
	    $length = 3;
        } elsif ($ucs < 0x200000) {
	    $mask = 0xf0;
	    $length = 4;
        } elsif ($ucs < 0x4000000) {
	    $mask = 0xf8;
	    $length = 5;
        } elsif ($ucs < 0x80000000) {
	    $mask = 0xfc;
	    $length = 6;
        } else {
	    die "unicode codepoint too big, $i\n";
        }

        $offset = 6 * ($length - 1);
	$result .= pack('C', ($ucs >> $offset) | $mask);
	$mask = 0x80;
	while ($offset > 0) {
	    $offset -= 6;
	    $result .= pack('C', (($ucs >> $offset) & 0x3f) | $mask);
	}
    }

    return $result;
}

sub to_eucjp ($) {
    my $result = $_[0];
    $result =~ s/ //g;
    return $result;
}
