/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.JIT;
import sun.misc.TimeStamps;
import sun.misc.Version;

public final class CVM {
    private static String mainClassName;
    private static String[] mainArgs;
    private static String savedNativeOptions;
    public static final int ARG_PARSE_UNINIT = 0;
    public static final int ARG_PARSE_OK = 1;
    public static final int ARG_PARSE_ERR = 2;
    public static final int ARG_PARSE_EXITVM = 3;
    public static final int ARG_PARSE_USAGE = 4;
    private static int parseStatus;
    private static String[] usrPaths;
    private static String[] sysPaths;
    private static String[] builtinPaths;
    public static final int DEBUGFLAG_TRACE_OPCODE = 1;
    public static final int DEBUGFLAG_TRACE_METHOD = 2;
    public static final int DEBUGFLAG_TRACE_STATUS = 4;
    public static final int DEBUGFLAG_TRACE_FASTLOCK = 8;
    public static final int DEBUGFLAG_TRACE_DETLOCK = 16;
    public static final int DEBUGFLAG_TRACE_MUTEX = 32;
    public static final int DEBUGFLAG_TRACE_CS = 64;
    public static final int DEBUGFLAG_TRACE_GCSTARTSTOP = 128;
    public static final int DEBUGFLAG_TRACE_GCSCAN = 256;
    public static final int DEBUGFLAG_TRACE_GCSCANOBJ = 512;
    public static final int DEBUGFLAG_TRACE_GCALLOC = 1024;
    public static final int DEBUGFLAG_TRACE_GCCOLLECT = 2048;
    public static final int DEBUGFLAG_TRACE_GCSAFETY = 4096;
    public static final int DEBUGFLAG_TRACE_CLINIT = 8192;
    public static final int DEBUGFLAG_TRACE_EXCEPTIONS = 16384;
    public static final int DEBUGFLAG_TRACE_MISC = 32768;
    public static final int DEBUGFLAG_TRACE_BARRIERS = 65536;
    public static final int DEBUGFLAG_TRACE_STACKMAPS = 131072;
    public static final int DEBUGFLAG_TRACE_CLASSLOADING = 262144;
    public static final int DEBUGFLAG_TRACE_CLASSLOOKUP = 524288;
    public static final int DEBUGFLAG_TRACE_TYPEID = 0x100000;
    public static final int DEBUGFLAG_TRACE_VERIFIER = 0x200000;
    public static final int DEBUGFLAG_TRACE_WEAKREFS = 0x400000;
    public static final int DEBUGFLAG_TRACE_CLASSUNLOAD = 0x800000;
    public static final int DEBUGFLAG_TRACE_CLASSLINK = 0x1000000;
    public static final int DEBUGFLAG_TRACE_LVM = 0x2000000;
    public static final int DEBUGFLAG_TRACE_JVMTI = 0x4000000;
    public static final int DEBUGFLAG_TRACE_JITSTATUS = 1;
    public static final int DEBUGFLAG_TRACE_JITBCTOIR = 2;
    public static final int DEBUGFLAG_TRACE_JITCODEGEN = 4;
    public static final int DEBUGFLAG_TRACE_JITSTATS = 8;
    public static final int DEBUGFLAG_TRACE_JITIROPT = 16;
    public static final int DEBUGFLAG_TRACE_JITINLINING = 32;
    public static final int DEBUGFLAG_TRACE_JITOSR = 64;
    public static final int DEBUGFLAG_TRACE_JITREGLOCALS = 128;
    public static final int DEBUGFLAG_TRACE_JITERROR = 256;
    public static final int DEBUGFLAG_TRACE_JITPATCHEDINVOKES = 256;

    private static void usage(String string) {
        System.err.println("usage: cvm [-fullversion] [-showversion] [-version] [-help] [-D<property>=<value>] [-XbuildOptions] [-XshowBuildOptions] [-XappName=<value>] [-cp <classpath> | -classpath <classpath>] " + string + "{<main class name> | -jar <jarfile> | -appletviewer <URL>} " + "[<arguments>...]");
    }

    public static int parseCommandLineOptions(String[] stringArray, String string, boolean bl) {
        parseStatus = 0;
        String string2 = System.getProperty("path.separator", ":");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object object;
            if (stringArray[i].startsWith("-D") || stringArray[i].startsWith("-XappName")) {
                if (CVM.addUserProperty(stringArray[i].substring(2))) continue;
                System.err.println("Error parsing property " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-version")) {
                Version.print(true);
                parseStatus = 3;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-showversion")) {
                Version.print(true);
                continue;
            }
            if (stringArray[i].startsWith("-Xnoagent")) continue;
            if (stringArray[i].startsWith("-Xtrace:")) {
                object = stringArray[i].substring(8);
                n = Integer.decode((String)object);
                CVM.setDebugFlags(n);
                continue;
            }
            if (stringArray[i].startsWith("-agentlib") || stringArray[i].startsWith("-agentpath")) {
                if (!CVM.agentlibSupported()) {
                    System.err.println("-agentlib, -agentpath not supported");
                    CVM.usage(string);
                    parseStatus = 2;
                    return parseStatus;
                }
                arrayList2.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-Xrun")) {
                if (!CVM.xrunSupported()) {
                    System.err.println("-Xrun not supported");
                    CVM.usage(string);
                    parseStatus = 2;
                    return parseStatus;
                }
                arrayList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-Xdebug")) {
                if (CVM.xdebugSet()) continue;
                System.err.println("-Xdebug not supported, debugging not enabled");
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-XtimeStamping")) {
                TimeStamps.enable();
                continue;
            }
            if (stringArray[i].startsWith("-Xjit:")) {
                object = stringArray[i].substring(6);
                if (JIT.reparseJitOptions((String)object)) continue;
                System.err.println("Error parsing JIT args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-Xverify:")) {
                object = stringArray[i].substring(9);
                if (CVM.parseVerifyOptions((String)object)) continue;
                System.err.println("Error parsing verify args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-Xopt:")) {
                object = stringArray[i].substring(6);
                if (CVM.parseXoptOptions((String)object)) continue;
                System.err.println("Error parsing -Xopt args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-Xss")) {
                object = stringArray[i].substring(4);
                if (CVM.parseXssOption((String)object)) continue;
                System.err.println("Error parsing -Xss args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-Xgc:")) {
                object = stringArray[i].substring(5);
                if (CVM.parseXgcOptions((String)object)) continue;
                System.err.println("Error parsing -Xgc args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-fullversion")) {
                Version.print(false);
                parseStatus = 3;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-ea") || stringArray[i].startsWith("-enableassertions") || stringArray[i].startsWith("-da") || stringArray[i].startsWith("-disableassertions") || stringArray[i].startsWith("-esa") || stringArray[i].startsWith("-enablesystemassertions") || stringArray[i].startsWith("-dsa") || stringArray[i].startsWith("-disablesystemassertions")) {
                if (CVM.parseAssertionOptions(stringArray[i])) continue;
                System.err.println("Error parsing assertion args " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-XbuildOptions")) {
                CVM.printBuildOptions();
                parseStatus = 3;
                return parseStatus;
            }
            if (stringArray[i].startsWith("-XshowBuildOptions")) {
                CVM.printBuildOptions();
                continue;
            }
            if (stringArray[i].startsWith("-Xcvm") || stringArray[i].startsWith("-Xjar") || stringArray[i].startsWith("-appletviewer")) {
                Object object2;
                block37: {
                    if (stringArray[i].startsWith("-Xjar")) {
                        try {
                            object = new JarFile(stringArray[i].substring(6));
                            Manifest manifest = ((JarFile)object).getManifest();
                            mainClassName = null;
                            if (manifest != null) {
                                object2 = manifest.getMainAttributes();
                                mainClassName = ((Attributes)object2).getValue("Main-Class");
                            }
                            if (mainClassName == null) {
                                System.err.println("-jar: Could not find Main-Class manifest attribute");
                                CVM.usage(string);
                                parseStatus = 2;
                                return parseStatus;
                            }
                            break block37;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            parseStatus = 2;
                            return parseStatus;
                        }
                    }
                    mainClassName = stringArray[i].startsWith("-appletviewer") ? "sun.applet.AppletViewer" : stringArray[i].substring(5);
                }
                if (mainClassName.startsWith("-") || mainClassName.length() == 0) {
                    System.err.println("Main class name \"" + mainClassName + "\" is not valid");
                    CVM.usage(string);
                    parseStatus = 2;
                    return parseStatus;
                }
                mainClassName = mainClassName.replace('/', '.');
                int n2 = stringArray.length - i - 1;
                mainArgs = new String[n2];
                for (n = 0; n < n2; ++n) {
                    object2 = stringArray[i + n + 1];
                    if (!((String)object2).startsWith("-Xcvm")) {
                        throw new InternalError("Illegal use of -Xcvm internal command line options");
                    }
                    CVM.mainArgs[n] = ((String)object2).substring(5);
                }
                break;
            }
            if (stringArray[i].startsWith("-")) {
                if (stringArray[i].equals("-help")) {
                    CVM.usage(string);
                    parseStatus = 4;
                    return parseStatus;
                }
                if (bl || stringArray[i].equals("-jar") || stringArray[i].equals("-cp") || stringArray[i].equals("-classpath") || stringArray[i].startsWith("-Xcp") || stringArray[i].startsWith("-Xms") || stringArray[i].startsWith("-Xmx") || stringArray[i].startsWith("-Xserver") || stringArray[i].startsWith("-Xbootclasspath=") || stringArray[i].startsWith("-Xbootclasspath:") || stringArray[i].startsWith("-Xbootclasspath/a=") || stringArray[i].startsWith("-Xbootclasspath/a:")) continue;
                System.err.println("Unrecognized option " + stringArray[i]);
                CVM.usage(string);
                parseStatus = 2;
                return parseStatus;
            }
            if (stringArray[i].startsWith("_timeStamp")) continue;
            System.err.println("Unrecognized option " + stringArray[i]);
            CVM.usage(string);
            parseStatus = 2;
            return parseStatus;
        }
        savedNativeOptions = string;
        if (arrayList2.size() > 0) {
            if (!CVM.agentlibInitialize(arrayList2.size())) {
                return 2;
            }
            Object[] objectArray = arrayList2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (CVM.agentlibProcess((String)objectArray[i])) continue;
                return 2;
            }
        }
        if (arrayList.size() > 0) {
            if (!CVM.xrunInitialize(arrayList.size())) {
                return 2;
            }
            Object[] objectArray = arrayList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (CVM.xrunProcess((String)objectArray[i])) continue;
                return 2;
            }
        }
        parseStatus = 1;
        return parseStatus;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    private static boolean addUserProperty(String string) {
        String string2;
        String string3;
        int n = string.indexOf(61);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        }
        System.setProperty(string3, string2);
        if (string3.equals("java.library.path")) {
            usrPaths = null;
        } else if (string3.equals("sun.boot.library.path")) {
            sysPaths = null;
        }
        return true;
    }

    private static void printPath(String string, String[] stringArray) {
        System.err.print(string + " search path: ");
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.print("[" + stringArray[i] + "] ");
        }
        System.err.println();
    }

    public static String[] getUserLibrarySearchPaths() {
        if (usrPaths == null) {
            usrPaths = CVM.initializePath("java.library.path");
        }
        return usrPaths;
    }

    public static String[] getSystemLibrarySearchPaths() {
        if (sysPaths == null) {
            sysPaths = CVM.initializePath("sun.boot.library.path");
        }
        return sysPaths;
    }

    public static String[] getBuiltinLibrarySearchPaths() {
        if (builtinPaths == null) {
            builtinPaths = CVM.initializePath("java.library.builtins");
        }
        return builtinPaths;
    }

    public static int getParseStatus() {
        return parseStatus;
    }

    public static String getMainClassName() {
        return mainClassName.replace('.', '/');
    }

    public static String[] getMainArguments() {
        return mainArgs;
    }

    static void resetMain() {
        mainClassName = null;
        mainArgs = null;
    }

    static void runMain() throws Throwable {
        if (parseStatus != 1) {
            return;
        }
        if (mainClassName == null) {
            System.err.println("Main class name missing.");
            CVM.usage(savedNativeOptions);
            return;
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class clazz = classLoader.loadClass(mainClassName);
        Class[] classArray = new Class[]{mainArgs.getClass()};
        Method method = clazz.getMethod("main", classArray);
        method.setAccessible(true);
        Object[] objectArray = new Object[]{mainArgs};
        try {
            method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public static native void setSystemClassLoader(ClassLoader var0);

    public static native int checkDebugFlags(int var0);

    public static native int setDebugFlags(int var0);

    public static native int clearDebugFlags(int var0);

    public static native int restoreDebugFlags(int var0, int var1);

    public static native int checkDebugJITFlags(int var0);

    public static native int setDebugJITFlags(int var0);

    public static native int clearDebugJITFlags(int var0);

    public static native int restoreDebugJITFlags(int var0, int var1);

    public static native void copyBooleanArray(boolean[] var0, int var1, boolean[] var2, int var3, int var4);

    public static native void copyByteArray(byte[] var0, int var1, byte[] var2, int var3, int var4);

    public static native void copyCharArray(char[] var0, int var1, char[] var2, int var3, int var4);

    public static native void copyShortArray(short[] var0, int var1, short[] var2, int var3, int var4);

    public static native void copyIntArray(int[] var0, int var1, int[] var2, int var3, int var4);

    public static native void copyFloatArray(float[] var0, int var1, float[] var2, int var3, int var4);

    public static native void copyLongArray(long[] var0, int var1, long[] var2, int var3, int var4);

    public static native void copyDoubleArray(double[] var0, int var1, double[] var2, int var3, int var4);

    public static native void copyObjectArray(Object[] var0, int var1, Object[] var2, int var3, int var4);

    public static void copyArray(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        System.arraycopy(objectArray, n, objectArray2, n2, n3);
    }

    public static native void executeClinit(Class var0);

    public static native void freeClinit(Class var0);

    static native void executeLoadSuperClasses(Class var0);

    public static native void disableRemoteExceptions();

    public static native void enableRemoteExceptions();

    public static native void throwRemoteException(Thread var0, Throwable var1);

    public static native boolean maskInterrupts();

    public static native void unmaskInterrupts();

    public static native Error throwLocalException(Throwable var0);

    public static native void setContextArtificial();

    public static native boolean callerCLIsMIDCLs();

    public static native boolean isMIDPContext();

    public static native boolean inMainLVM();

    public static native void gcDumpHeapSimple();

    public static native void gcDumpHeapVerbose();

    public static native void gcDumpHeapStats();

    public static native void trace(int var0);

    public static native void setDebugEvents(boolean var0);

    public static native void postThreadExit();

    public static native boolean objectInflatePermanently(Object var0);

    public static native void setThreadNoCompilationsFlag(boolean var0);

    public static native Class getCallerClass(int var0);

    public static native boolean isCompilerSupported();

    public static native void dumpCompilerProfileData();

    public static native void dumpStats();

    public static native void markCodeBuffer();

    public static native void initializeJITPolicy();

    public static native boolean initializeAOTCode();

    public static native boolean parseVerifyOptions(String var0);

    public static native boolean parseXoptOptions(String var0);

    public static native boolean parseXgcOptions(String var0);

    public static native boolean parseXssOption(String var0);

    public static native boolean parseAssertionOptions(String var0);

    public static native boolean agentlibSupported();

    public static native boolean agentlibInitialize(int var0);

    public static native boolean agentlibProcess(String var0);

    public static native boolean xrunSupported();

    public static native boolean xrunInitialize(int var0);

    public static native boolean xrunProcess(String var0);

    public static native boolean xdebugSet();

    public static native boolean simpleLockGrab(Object var0);

    public static native void simpleLockRelease(Object var0);

    public static void printBuildOptions() {
        System.err.print(CVM.getBuildOptionString(null));
    }

    private static native String getBuildOptionString(Object var0);

    public static native long nanoTime();

    public static native void setURLConnectionDefaultUseCaches(boolean var0);

    public static native void clearURLClassLoaderUcpField(URLClassLoader var0);

    static class Preloader {
        Preloader() {
        }

        public static boolean registerClassLoader(String string, ClassLoader classLoader) {
            String string2 = Preloader.getClassLoaderNames();
            if (string2 == null) {
                return false;
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                if (string.equals(stringTokenizer.nextToken())) {
                    Preloader.registerClassLoader0(n, classLoader);
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static native String getClassLoaderNames();

        private static native void registerClassLoader0(int var0, ClassLoader var1);
    }
}

