/* CedillaAtom.java
 * =========================================================================
 * This file is part of the JLaTeXMath Library - http://forge.scilab.org/jlatexmath
 *
 * Copyright (C) 2009 DENIZET Calixte
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 *
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

package org.scilab.forge.jlatexmath;

/**
 * An atom with a cedilla.
 */
public class CedillaAtom extends Atom {
    
    private Atom base;

    public CedillaAtom(Atom base) {
	this.base = base;
    }
    
    /*public Box createBox(TeXEnvironment env) {
	Box b = base.createBox(env);
	VerticalBox vb = new VerticalBox();
	vb.add(b);
	vb.add(cedilla.createBox(env));
	float f = vb.getHeight() + vb.getDepth();
	vb.setHeight(b.getHeight());
	vb.setDepth(f - b.getHeight());
	return vb;
	} */

    public Box createBox(TeXEnvironment env) {
	Box b = base.createBox(env);
	VerticalBox vb = new VerticalBox();
	vb.add(b);
	Char ch = env.getTeXFont().getChar("jlatexmathcedilla", env.getStyle());
	float italic = ch.getItalic();
	Box cedilla = new CharBox(ch);
	Box y;
	if (Math.abs(italic) > TeXFormula.PREC) {
            y = new HorizontalBox(new StrutBox(-italic, 0, 0, 0));
            y.add(cedilla);
        } else
            y = cedilla;

	Box ce = new HorizontalBox(y, b.getWidth(), TeXConstants.ALIGN_CENTER);
	float x = new SpaceAtom(TeXConstants.UNIT_MU, 0.4f, 0, 0).createBox(env).getWidth();
	vb.add(new StrutBox(0, -x, 0, 0));
	vb.add(ce);
	float f = vb.getHeight() + vb.getDepth();
	vb.setHeight(b.getHeight());
	vb.setDepth(f - b.getHeight());
	return vb;
    } 
}
