package de.intarsys.tools.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class ThreadFilter implements Filter {

	final private Thread thread;

	public ThreadFilter() {
		this(Thread.currentThread());
	}

	public ThreadFilter(Thread thread) {
		super();
		this.thread = thread;
	}

	public boolean isLoggable(LogRecord record) {
		return thread == Thread.currentThread();
	}

}
