/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public final class Scenario
implements Serializable {
    static final String VM_KEY = "vm";
    static final String TRIAL_KEY = "trial";
    private Map<String, String> variables;

    public Scenario(Map<String, String> variables) {
        this.variables = new LinkedHashMap<String, String>(variables);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public Map<String, String> getVariables(Set<String> names) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variables);
        result.keySet().retainAll(names);
        if (!result.keySet().equals(names)) {
            throw new IllegalArgumentException("Not all of " + names + " are in " + result.keySet());
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof Scenario && ((Scenario)o).getVariables().equals(this.variables);
    }

    public int hashCode() {
        return this.variables.hashCode();
    }

    public String toString() {
        return "Scenario" + this.variables;
    }

    private Scenario() {
    }
}

