/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "test.h"
#include "flux.h"
#include <sys/time.h>


int test_fifobuf_integrity_small()
{
  FIFOBUF *fib;
  unsigned char c;
  int i, r;

  fib = fifobuf_new(2, 16, 32);
  
  for (i = 0; i < 16 * 32; i++)
  {
    c = i & 255;
    r = fifobuf_enqueue(fib, &c, 1);
    if (r < 1) break;
  }
  
  if (r < 1)
  {
    fifobuf_free(fib);
    return(-1);
  }

  for (i = 0; i < 16 * 32; i++)
  {
    r = fifobuf_dequeue(fib, &c, 1);
    if (r < 1) break;

    if (c != (i & 255)) { r = -1; break; }
  }
  
  fifobuf_free(fib);
  if (r < 1) return(-1);
  return(0);
}


int test_fifobuf_integrity_large()
{
  FIFOBUF *fib;
  unsigned char c[1536];
  int r;

  fib = fifobuf_new(2, 3, 512);

  r = fifobuf_enqueue(fib, c, 1536);
  if (r < 1536)
  {
    fifobuf_free(fib);
    return(-1);
  }

  r = fifobuf_dequeue(fib, c, 1536);

  fifobuf_free(fib);

  if (r < 1536) return(-1);
  return(0);
}


int test_fifobuf_through_small()
{
  FIFOBUF *fib;
  unsigned char c[256];
  unsigned int i;
  double r1;

  fib = fifobuf_new(2, 64, 4);

  bm_start();

  for (i = 0; i < 100000; i++)
  {
    fifobuf_enqueue(fib, c, 256);
    fifobuf_dequeue(fib, c, 256);
  }

  bm_end();
  
  fifobuf_free(fib);

  r1 = 25600 / (bm_diff_get_usec() / 1000000);
  return((int) r1);
}


int test_fifobuf_through_large()
{
  FIFOBUF *fib;
  unsigned char c[256];
  unsigned int i;
  double r1;

  fib = fifobuf_new(2, 2, 128);

  bm_start();

  for (i = 0; i < 100000; i++)
  {
    fifobuf_enqueue(fib, c, 256);
    fifobuf_dequeue(fib, c, 256);
  }

  bm_end();
  
  fifobuf_free(fib);

  r1 = 25600 / (bm_diff_get_usec() / 1000000);
  return((int) r1);
}
