/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include "tt.h"
#include "url.h"
#include "cgi.h"
#include "fstring.h"

TT *cgi_args_get_to_ttree(char *args)
{
  TT *args_tt;
  char *item_str, *data_str, *temp_str;
  
  args_tt = tt_new_with_data("args", 4);
  
  for (;;)
  {
    args = cgi_get_item_next(args, &item_str, &data_str);
    if (!args) break;

    temp_str = url_esc_to_8bit(item_str);
    args_tt = tt_new_with_parent_and_data(args_tt, temp_str, strlen(temp_str));
    free(temp_str);
    
    temp_str = url_esc_to_8bit(data_str);
    tt_new_with_parent_and_data(args_tt, temp_str, strlen(temp_str));
    free(temp_str);
    
    args_tt = tt_get_parent(args_tt);
    free(item_str);
    free(data_str);
  }
  
  return(args_tt);
}


TT *cgi_args_post_to_ttree(FILE *in)
{
  TT *args_tt;
  char *args;
  
  args = afgets(in, 0);
  if (!args) return(0);
  
  args_tt = cgi_args_get_to_ttree(args);
  return(args_tt);
}
