/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef _FIFOBUF_H
#define _FIFOBUF_H 1

#ifndef LIBFLUX_BUILD
#  include <flux/types.h>
#else
#  include "types.h"
#endif

/* Find this ugly? Just think of the nice frontend */

#define FIFOBUF_FOR_DATA(fib, lim, p, len)                  \
  for(fib->i = lim < fib->enqueued ? lim : fib->enqueued,   \
      fib->node_cur = fib->node_out,                        \
      p = fib->node_out->data + fib->byte_out,              \
      len = (fib->bufsize - fib->byte_out) < fib->i ?       \
            (fib->bufsize - fib->byte_out) : fib->i;        \
                                                            \
      fib->i;                                               \
                                                            \
      fib->i -= len,                                        \
      fib->node_cur = fib->node_cur->next,                  \
      p = fib->node_cur->data,                              \
      len = fib->bufsize < fib->i ? fib->bufsize : fib->i)

#define fifobuf_free_max(fib) (((fib)->buffers_max * (fib)->bufsize) - (fib)->enqueued)
#define fifobuf_free_cur(fib) (((fib)->buffers_cur * (fib)->bufsize) - (fib)->enqueued)
#define fifobuf_free_min(fib) (((fib)->buffers_min * (fib)->bufsize) - (fib)->enqueued)
#define _fifobuf_fitnodes(fib, len) (((len) / (fib)->bufsize) + 1)

typedef struct fifobuf_head
{
  struct fifobuf_node *node_out, *node_in;  /* Currently enqueuing from/to */
  struct fifobuf_node *node_cur;  /* Private pointer */
  u32 byte_out, byte_in;  /* Within start/end nodes */
  u32 enqueued;              /* Number of bytes enqueued */
  u32 bufsize;               /* Size of each buffer node */
  u32 i;                     /* Private counter */
  u16 buffers_min, buffers_max, buffers_cur;
}
FIFOBUF;

struct fifobuf_node
{
  struct fifobuf_node *prev, *next;
  unsigned char *data;
};


/* fifobuf-fifobuf.c */
struct fifobuf_node *_fifobuf_node_add(FIFOBUF *fib);
void _fifobuf_node_del(FIFOBUF *fib);
FIFOBUF *fifobuf_new(unsigned short buffers_min, unsigned short buffers_max, unsigned long bufsize);
void fifobuf_free(FIFOBUF *fib);
long fifobuf_enqueue(FIFOBUF *fib, void *data, unsigned long len);
unsigned long fifobuf_dequeue(FIFOBUF *fib, void *data, unsigned long len);
void *fifobuf_dequeue_dyn(FIFOBUF *fib, unsigned long len);
unsigned long fifobuf_peek(FIFOBUF *fib, void *data, unsigned long len);
unsigned long fifobuf_drop(FIFOBUF *fib, unsigned long len);
unsigned long fifobuf_do(FIFOBUF *fib, unsigned long len, int (*func)(void *data, unsigned long len, void *extra), void *extra);

#endif  /* _FIFOBUF_H */
