/* 
 * Copyright (c) 2005 FlexDock Development Team. All rights reserved. 
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of 
 * this software and associated documentation files (the "Software"), to deal in the 
 * Software without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all 
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE.
 */
package org.flexdock.perspective.persist.xml;

import java.util.HashMap;

/**
 * Created on 2005-06-03
 * 
 * @author <a href="mailto:mati@sz.home.pl">Mateusz Szczap</a>
 * @version $Id: SerializerRegistry.java,v 1.5 2005/07/05 14:53:29 marius Exp $
 */
public class SerializerRegistry {

    private static HashMap m_serializers = new HashMap();
    
    public static void registerSerializer(Class clazz, ISerializer serializer) {
        if (clazz == null) throw new IllegalArgumentException("clazz cannot be null");
        if (serializer == null) throw new IllegalArgumentException("serializer cannot be null");

        m_serializers.put(clazz, serializer);
    }
    
    public static ISerializer getSerializer(Class clazz) {
        if (clazz == null) throw new IllegalArgumentException("clazz cannot be null");

        return (ISerializer) m_serializers.get(clazz);
    }
    
}
