/*
 * Ready-made utility classes for Debtags
 *
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <wibble/mixin.h>
#include <ept/cache/tag.h>
#if 0
#include <apt-front/cache/component/tagmap.h>
#endif

#ifndef EPT_CACHE_DEBTAGS_UTILS_H
#define EPT_CACHE_DEBTAGS_UTILS_H

#if 0
#include <tagcoll/CardinalityStore.h>
#include <debtags/Vocabulary.h>
#include <debtags/Filters.h>
#include <debtags/Status.h>
#include <map>
#include <debtags/Tag.h>
#include <tagcoll/Filter.h>
#endif

namespace ept {
namespace t {
namespace cache {

template<typename C> class Facet;

namespace debtags {

/**
 * Convert a collection of ITEMs tagged with Vocabulary to a collection of
 * ITEMs tagged with only the facets.
 */
template<typename OUT, typename C>
class TagToFacet : public wibble::mixin::OutputIterator< TagToFacet<OUT, C> >
{
protected:
	OUT out;

public:
	TagToFacet(const OUT& out) : out(out) {}

	template<typename ITEMS, typename TAGS>
	TagToFacet<OUT, C>& operator=(const std::pair<ITEMS, TAGS>& data)
	{
		std::set< Facet<C> > facets;
		for (typename TAGS::const_iterator i = data.second.begin();
				i != data.second.end(); ++i)
			facets.insert(i->facet());
		*out = make_pair(data.first, facets);
		++out;
		return *this;
	}
};

template<typename C>
struct Utils
{
	template<typename OUT>
	static TagToFacet<OUT, C> tagToFacet(const OUT& out)
	{
		return TagToFacet<OUT, C>(out);
	}
};

#if 0

/**
 * This class should help in implementing full-text + debtags searches, but
 * it's still very much in the making
 */
template <class ITEM>
class SearchHelper
{
protected:
	static const int dist = 7;

	class CardCompute : public std::map<entity::Tag, int>, public Tagcoll::Consumer<ITEM, entity::Tag>
	{
		void consumeItemUntagged(const ITEM&) {}
		void consumeItem(const ITEM&, const Tagcoll::OpSet<entity::Tag>& tags)
		{
			for (Tagcoll::OpSet<entity::Tag>::const_iterator i = tags.begin();
					i != tags.end(); i++)
				(*this)[*i]++;
		}
		void consumeItems(const Tagcoll::OpSet<ITEM>& items, const Tagcoll::OpSet<entity::Tag>& tags)
		{
			for (Tagcoll::OpSet<entity::Tag>::const_iterator i = tags.begin();
					i != tags.end(); i++)
				(*this)[*i] += items.size();
		}
	public:
		virtual ~CardCompute() {}
	};

	component::TagMap& debtags;
	Tagcoll::OpSet<ITEM> startPackages;
	Tagcoll::OpSet<entity::Tag> wanted;
	Tagcoll::OpSet<entity::Tag> unwanted;
	Tagcoll::OpSet<ITEM> found;
	Tagcoll::OpSet<entity::Tag> pivotTags;
	CardCompute cardComputer;
	int cards[dist];
	entity::Tag tags[dist];

	void storeTag(const entity::Tag& tag, int card = -1, int idx = 0);

public:
	SearchHelper(component::TagMap& debtags) : debtags(debtags) {}

	void clearStartPackages() { startPackages.clear(); }
	void addStartPackage(const ITEM& item) { startPackages += item; }

	void clearWanted() { wanted.clear(); }
	void addWanted(const entity::Tag& tag) { wanted += tag; }
	const Tagcoll::OpSet<entity::Tag>& getWanted() const { return wanted; }

	void clearUnwanted() { unwanted.clear(); }
	void addUnwanted(const entity::Tag& tag) { unwanted += tag; }
	const Tagcoll::OpSet<entity::Tag>& getUnwanted() const { return unwanted; }

	const Tagcoll::OpSet<entity::Tag>& getPivot() const { return pivotTags; }

	const Tagcoll::OpSet<ITEM>& getFound() const { return found; }

	void compute();
};


/**
 * Compute "Special-case packages"
 *
 * Compute a list of those packages whose tag set is 'strange' compared to the
 * other packages.
 *
 * The list corresponds to those packages reported by 
 * debtags facetcoll | tagcoll findspecials
 */
template <class ITEM>
class Specials : public Tagcoll::Consumer<ITEM, entity::Tag>
{
protected:
	Tagcoll::CardinalityStore<ITEM, entity::Facet> coll;
	TagToFacet<ITEM> tagStripper;
	unsigned int maxPerGroup;
	bool computed;

	virtual void consumeItemUntagged(const ITEM& item)
	{
		tagStripper.consume(item);
	}
	virtual void consumeItem(const ITEM& item, const Tagcoll::OpSet<entity::Tag>& tags)
	{
		tagStripper.consume(item, tags);
	}
	virtual void consumeItemsUntagged(const Tagcoll::OpSet<ITEM>& items)
	{
		tagStripper.consume(items);
	}
	virtual void consumeItems(const Tagcoll::OpSet<ITEM>& items, const Tagcoll::OpSet<entity::Tag>& tags)
	{
		tagStripper.consume(items, tags);
	}

public:
	Specials(unsigned int maxPerGroup = 0) :
		tagStripper(coll), maxPerGroup(maxPerGroup), computed(false) {}
	virtual ~Specials() {}
	
	bool isComputed() const { return computed; }
	void compute(/*Status* tracker = 0*/);
	void clear()
	{
		coll = Tagcoll::CardinalityStore<ITEM, entity::Facet>(); specials.clear();
		computed = false;
	}

	std::map< entity::Facet, Tagcoll::OpSet<ITEM> > specials;
};

#endif

}
}
}
}

// vim:set ts=4 sw=4:
#endif
