/***************************************************************************
                           cxml.h  -  description
                             -------------------
    begin                : Sun Jun 9 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CXML_H
#define CXML_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

#define XML_FALSE			"false"
#define XML_TRUE			"true"

class DLL_EXPORT CXml : public CObject {

public:
	/** */
	CXml();
	/** */
	virtual ~CXml();

	/** */
	xmlDocPtr doc();
	/** */
	CString name( xmlNodePtr node );
	/** */
	CString content( xmlNodePtr node );
	/** */
	CString prop( xmlNodePtr node, CString prop );
	/** */
	xmlNodePtr xmlNewBoolChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, bool b );
	/** */
	xmlNodePtr xmlNewStringChild( xmlNodePtr parent, xmlNsPtr ns, const xmlChar *name, CString s, bool createempty = TRUE );
	/** */
	void xmlNewStringProp( xmlNodePtr node, CString prop, CString value );

	/** */
	bool getBoolChild( xmlNodePtr node );

	/** */
	bool NewDoc();
	/** */
	bool ParseFile( CString name );
	/** */
	bool ParseMemory( const char * s, int size );

	/** */
	CString ToUTF8( CString & s, CString from_codec = "", bool nosub = FALSE );
	/** */
	CString FromUtf8( CString & s, CString to_codec = "", bool nosub = FALSE );
	/** */
	CString ToUTF8( const char * s, CString from_codec = "", bool nosub = FALSE );
	/** */
	CString FromUtf8( const char * s, CString to_codec = "", bool nosub = FALSE );

private:
	/** */
	void FreeDoc();
	/** */
	CString xml_UTF8ToOutput( char * s, int len, CString to_codec );
	/** */
	CString xml_InputToUTF8( char * s, int len, CString from_codec );

	/** */
	xmlDocPtr pDoc;
	/** Encoding from LANG environment variable */
	CString m_sLocaleEnc;
};

inline xmlDocPtr CXml::doc()
{ return pDoc; }
inline CString CXml::name( xmlNodePtr node )
{ return CString(((char*)node->name)); }

#endif
