/***************************************************************************
                           ciconv.cpp  -  DCLib C++ iconv wrapper
                             -------------------
    begin                : Thu Sep 20 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef ICONV_CONST
#define ICONV_CONST
#endif

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "ciconv.h"

/** calls iconv_open */
CIconv::CIconv( CString from, CString to )
{
	if ( (from.ToLower() == "none") || (to.ToLower() == "none") )
	{
		// printf( "CIconv: encoding is disabled\n" );
		disabled = TRUE;
	}
	else
	{
		cd = iconv_open( to.Data(), from.Data() );
		if ( cd == (iconv_t)(-1) )
		{
			perror( "CIconv::CIconv" );
			printf( "CIconv: encoding disabled - iconv_open failed\n" );
			disabled = TRUE;
		}
		else
		{
			disabled = FALSE;
		}
	}
}

/** calls iconv_close */
CIconv::~CIconv()
{
	if ( disabled == FALSE )
	{
		iconv_close( cd );
	}
}

/** calls iconv */
CString CIconv::encode( CString orig )
{
	if ( disabled == TRUE )
	{
		return orig;
	}
	
	if ( orig == "" )
	{
		return "";
	}
	
	CString result = "";
	size_t retval;
	
	size_t inleft = orig.Length();
	size_t outleft = inleft * 4;
	
	char * inbuf = orig.Data();
	char * outbuf = (char*) calloc( 1, outleft );
	char * outstart = outbuf;
	
	while ( inleft > 0 )
	{
		retval = iconv( cd, (ICONV_CONST char **)&inbuf, &inleft, &outbuf, &outleft );
	
		if ( retval == (size_t) -1 )
		{
			// handle invalid multibyte sequence
			if ( errno == EILSEQ )
			{
				outstart[outbuf - outstart] = '_';
				
				inbuf++;
				inleft--;
				
				outbuf++;
				outleft--;
			}
			else
			{
				printf("iconv fail: %d\n", retval);
				perror("CIconv::encode");
				
				free(outstart);
				return orig;
			}
		}
	}
		
	result = outstart;
	free(outstart);
	
	//printf( "orig=\"%s\" len=%d\nresult=\"%s\" len=%d\n", orig.Data(), orig.Length(), result.Data(), result.Length() );
	
	return result;
	
}
