/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 581
#define YYNRULE 309
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   287,   71,   71,   71,   56,  203,  182,  432,   91,   91,
 /*    10 */    91,   91,  295,   74,   74,   74,   74,   66,   66,   71,
 /*    20 */    71,   71,   56,  543,  406,  295,  445,  451,   67,   74,
 /*    30 */    74,   74,   74,   66,   66,   71,   71,   71,   56,  281,
 /*    40 */   424,  444,  442,  518,  188,   60,   85,  306,  455,  456,
 /*    50 */   452,  452,   87,   87,   91,   91,   91,   91,  481,   74,
 /*    60 */    74,   74,   74,   66,   66,   71,   71,   71,   56,  287,
 /*    70 */   515,  577,  432,  479,  427,   59,   74,   74,   74,   74,
 /*    80 */    66,   66,   71,   71,   71,   56,  171,  114,  254,  316,
 /*    90 */   267,  347,  199,  241,  538,  445,  451,  236,  537,   64,
 /*   100 */   243,  254,  316,  267,  347,  199,  241,  429,  429,  429,
 /*   110 */   344,  578,  287,  243,   60,   85,  306,  455,  456,  452,
 /*   120 */   452,   87,   87,   91,   91,   91,   91,  196,   74,   74,
 /*   130 */    74,   74,   66,   66,   71,   71,   71,   56,  445,  451,
 /*   140 */    66,   66,   71,   71,   71,   56,  374,  435,  436,  191,
 /*   150 */   390,   70,   79,   69,  151,  214,  471,   60,   85,  306,
 /*   160 */   455,  456,  452,  452,   87,   87,   91,   91,   91,   91,
 /*   170 */    56,   74,   74,   74,   74,   66,   66,   71,   71,   71,
 /*   180 */    56,  546,  200,  279,  287,  335,  339,  343,  491,  891,
 /*   190 */   136,  383,  444,  409,    2,  219,  390,  348,  527,   17,
 /*   200 */   362,   70,  469,   69,  151,  410,  440,  209,  153,  212,
 /*   210 */   445,  451,  146,  147,  520,  391,  392,  481,  411,  545,
 /*   220 */   373,  515,  423,   44,  514,  427,  563,   61,   75,   60,
 /*   230 */    85,  306,  455,  456,  452,  452,   87,   87,   91,   91,
 /*   240 */    91,   91,  424,   74,   74,   74,   74,   66,   66,   71,
 /*   250 */    71,   71,   56,  287,  385,  376,  487,  494,  429,  429,
 /*   260 */   429,  391,  392,  200,  148,  300,  335,  339,  343,  500,
 /*   270 */   327,  256,  259,   70,  359,   69,  151,  466,  348,  445,
 /*   280 */   451,  214,  312,  386,  516,  549,    9,  169,  218,  501,
 /*   290 */   390,   70,  179,   69,  151,  184,  423,    3,   60,   85,
 /*   300 */   306,  455,  456,  452,  452,   87,   87,   91,   91,   91,
 /*   310 */    91,  567,   74,   74,   74,   74,   66,   66,   71,   71,
 /*   320 */    71,   56,  287,  362,  519,  459,  424,   88,  362,  424,
 /*   330 */   362,  149,  200,  401,   21,  335,  339,  343,  166,  152,
 /*   340 */     1,  362,  299,  357,  390,  423,   30,  348,  445,  451,
 /*   350 */   423,   44,  423,   44,  317,  391,  392,  145,  528,  579,
 /*   360 */   882,  278,  882,  423,   46,  424,  257,   60,   85,  306,
 /*   370 */   455,  456,  452,  452,   87,   87,   91,   91,   91,   91,
 /*   380 */   378,   74,   74,   74,   74,   66,   66,   71,   71,   71,
 /*   390 */    56,  287,  519,  366,  409,  301,  109,  506,  280,  276,
 /*   400 */   576,  529,   21,  368,  235,  466,  410,  466,  390,  391,
 /*   410 */   392,  574,  323,  283,  458,  458,  474,  445,  451,  411,
 /*   420 */   519,  407,  460,  579,  881,  371,  881,  490,  540,  572,
 /*   430 */    21,  408,  296,  159,  287,  363,   60,   85,  306,  455,
 /*   440 */   456,  452,  452,   87,   87,   91,   91,   91,   91,  362,
 /*   450 */    74,   74,   74,   74,   66,   66,   71,   71,   71,   56,
 /*   460 */   445,  451,   81,  560,  576,   92,  326,  424,  305,  435,
 /*   470 */   436,  423,   44,  391,  392,  323,  238,  458,  458,   60,
 /*   480 */    85,  306,  455,  456,  452,  452,   87,   87,   91,   91,
 /*   490 */    91,   91,  329,   74,   74,   74,   74,   66,   66,   71,
 /*   500 */    71,   71,   56,  287,  542,  562,  364,  266,  144,  323,
 /*   510 */   517,  458,  458,  333,  323,  215,  458,  458,  362,  512,
 /*   520 */   362,  390,   54,  564,  565,  432,  465,  402,  511,  445,
 /*   530 */   451,  212,  358,  422,  440,  209,  508,  421,  526,  495,
 /*   540 */   423,   46,  423,   41,  816,  525,  287,  354,   60,   85,
 /*   550 */   306,  455,  456,  452,  452,   87,   87,   91,   91,   91,
 /*   560 */    91,  506,   74,   74,   74,   74,   66,   66,   71,   71,
 /*   570 */    71,   56,  445,  451,  195,  181,  177,  168,  250,  489,
 /*   580 */   403,  228,  499,  498,  390,  212,  391,  392,  508,  291,
 /*   590 */   432,   60,   85,  306,  455,  456,  452,  452,   87,   87,
 /*   600 */    91,   91,   91,   91,  155,   74,   74,   74,   74,   66,
 /*   610 */    66,   71,   71,   71,   56,  135,  362,  130,  287,  249,
 /*   620 */   362,  289,  513,  550,  362,   92,  504,  390,  135,  362,
 /*   630 */   290,  362,  350,  362,  135,  243,  362,  422,  423,   42,
 /*   640 */   223,  421,  423,   41,  445,  451,  423,   25,  277,  391,
 /*   650 */   392,  423,  112,  423,   29,  423,   38,  370,  423,   37,
 /*   660 */   506,  287,   89,   60,   85,  306,  455,  456,  452,  452,
 /*   670 */    87,   87,   91,   91,   91,   91,  477,   74,   74,   74,
 /*   680 */    74,   66,   66,   71,   71,   71,   56,  445,  451,  292,
 /*   690 */   222,  417,  391,  392,  229,  298,  342,  506,  248,  506,
 /*   700 */   337,  270,  506,  464,  287,   12,   60,   85,  306,  455,
 /*   710 */   456,  452,  452,   87,   87,   91,   91,   91,   91,  478,
 /*   720 */    74,   74,   74,   74,   66,   66,   71,   71,   71,   56,
 /*   730 */   445,  451,  307,  175,  308,  180,  492,  205,   12,  238,
 /*   740 */   534,  535,  382,  334,  442,  319,  188,  287,  571,   60,
 /*   750 */    80,  306,  455,  456,  452,  452,   87,   87,   91,   91,
 /*   760 */    91,   91,  362,   74,   74,   74,   74,   66,   66,   71,
 /*   770 */    71,   71,   56,  445,  451,  195,  238,  202,  238,   20,
 /*   780 */   389,  238,  418,  432,  423,   51,  581,  385,  376,  419,
 /*   790 */   287,  340,  380,   85,  306,  455,  456,  452,  452,   87,
 /*   800 */    87,   91,   91,   91,   91,  362,   74,   74,   74,   74,
 /*   810 */    66,   66,   71,   71,   71,   56,  445,  451,  203,  453,
 /*   820 */   432,  536,  346,  536,  393,  394,  395,  423,   43,  438,
 /*   830 */   438,  290,  483,   83,  169,   84,  275,  306,  455,  456,
 /*   840 */   452,  452,   87,   87,   91,   91,   91,   91,  432,   74,
 /*   850 */    74,   74,   74,   66,   66,   71,   71,   71,   56,   62,
 /*   860 */   314,  433,    4,   22,  414,  415,  304,   19,  485,  140,
 /*   870 */   362,  615,  362,  193,  360,  384,  214,  362,    2,  176,
 /*   880 */   261,  475,  135,   62,  314,  432,    4,  446,  447,  315,
 /*   890 */   304,  377,  423,   53,  423,   26,  362,  481,  360,  423,
 /*   900 */    45,  214,  444,  352,  270,  362,  170,  424,  173,  449,
 /*   910 */   450,  362,  270,  424,  328,  377,  362,  150,  423,  111,
 /*   920 */   362,  264,   65,   90,  488,  272,  444,  423,  101,  293,
 /*   930 */    62,  322,  321,  423,   95,  427,  262,  448,  423,   28,
 /*   940 */   424,  270,  423,   34,  362,  242,   65,   90,  541,  476,
 /*   950 */   135,  424,  362,  318,   62,  322,  321,  503,  362,  427,
 /*   960 */   294,  119,  362,  502,  362,  441,  423,   16,  429,  429,
 /*   970 */   429,  430,  431,   15,  423,  110,   62,  314,  214,    4,
 /*   980 */   423,   23,  246,  304,  423,   50,  423,   98,  362,  548,
 /*   990 */   362,  360,  429,  429,  429,  430,  431,   15,  362,  484,
 /*  1000 */   362,  485,  362,  270,  362,  497,  362,  330,  377,  362,
 /*  1010 */   423,   33,  423,   49,  330,    6,  157,  186,  152,  444,
 /*  1020 */   423,   31,  423,   48,  423,   24,  423,   93,  423,   47,
 /*  1030 */   115,  423,   32,  362,  270,  575,  284,  270,  270,   65,
 /*  1040 */    90,  362,  476,  362,  557,  362,  428,   62,  322,  321,
 /*  1050 */   485,  273,  427,  183,  467,  423,   27,  274,  239,  258,
 /*  1060 */   245,  100,  345,  423,   36,  423,   52,  423,   35,  362,
 /*  1070 */   561,  362,  270,  204,  201,  556,  234,  362,  555,  553,
 /*  1080 */   207,  362,  240,  227,  362,  429,  429,  429,  430,  431,
 /*  1090 */    15,  423,   94,  423,   10,  187,  362,  545,  552,  423,
 /*  1100 */    39,  252,  185,  423,  113,  198,  423,   97,  247,  313,
 /*  1110 */   253,  302,  255,  269,  496,  331,  405,  406,  423,   40,
 /*  1120 */   332,  226,  224,  521,  225,  480,  338,  559,  507,  439,
 /*  1130 */   505,  379,  495,  437,  143,  220,  470,  399,  473,  303,
 /*  1140 */    61,  230,  573,   68,  231,  102,  103,  178,  320,  244,
 /*  1150 */   259,  413,  210,  285,  288,  570,  569,  568,  356,  214,
 /*  1160 */   211,  216,   73,  158,  367,  232,  472,  471,  369,   58,
 /*  1170 */   217,   86,  162,  271,   72,   63,  233,  396,  237,  310,
 /*  1180 */   426,  509,  208,  311,  126,  132,  510,  117,  398,  558,
 /*  1190 */   372,  251,  324,  417,  551,  129,  128,  127,  137,  416,
 /*  1200 */   404,  138,  197,  325,  397,  124,  544,  522,  523,  361,
 /*  1210 */   524,  341,  165,   76,  420,  263,  351,  532,  533,  482,
 /*  1220 */   268,  486,  174,  353,  388,    8,  530,  425,  468,  286,
 /*  1230 */   309,  412,   18,  365,   96,  118,  107,  213,   99,  387,
 /*  1240 */   566,  206,  141,   13,  133,  120,  443,  131,  617,  616,
 /*  1250 */   554,  190,  194,  457,  189,  192,   82,   78,   11,  125,
 /*  1260 */   547,  454,  336,  108,  106,  282,  260,  105,  265,  163,
 /*  1270 */    57,  169,  539,  123,   55,  349,  104,  167,  297,  121,
 /*  1280 */   219,  531,  139,  355,  172,  134,  156,   77,  122,  580,
 /*  1290 */   493,  400,  164,    7,   12,   14,  463,  160,  116,  462,
 /*  1300 */     5,  434,  375,  154,  461,  142,  558,  558,  381,  221,
 /*  1310 */   161,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,   81,   82,   83,   84,   21,  156,   23,   70,   71,
 /*    10 */    72,   73,   16,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  186,  187,   16,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,  159,
 /*    40 */   190,   59,  162,  163,  164,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  162,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */    88,   20,   88,  115,   92,   22,   75,   76,   77,   78,
 /*    80 */    79,   80,   81,   82,   83,   84,   90,   91,   92,   93,
 /*    90 */    94,   95,   96,   97,   25,   42,   43,  201,   29,   46,
 /*   100 */   104,   92,   93,   94,   95,   96,   97,  125,  126,  127,
 /*   110 */    41,   60,   16,  104,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   22,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    79,   80,   81,   82,   83,   84,  165,  166,  167,   19,
 /*   150 */    23,  218,   19,  220,  221,  111,   23,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */    84,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   11,   90,   92,   16,   93,   94,   95,   20,  140,
 /*   190 */   141,  142,   59,   12,  145,  104,   23,  105,  182,   69,
 /*   200 */   148,  218,  219,  220,  221,   24,   79,   80,  156,  228,
 /*   210 */    42,   43,   79,   80,  182,   88,   89,  162,   37,   49,
 /*   220 */    39,   88,  170,  171,  170,   92,   99,  122,  132,   61,
 /*   230 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   240 */    72,   73,  190,   75,   76,   77,   78,   79,   80,   81,
 /*   250 */    82,   83,   84,   16,    1,    2,  201,   20,  125,  126,
 /*   260 */   127,   88,   89,   90,   22,  213,   93,   94,   95,   30,
 /*   270 */   100,  101,  102,  218,  148,  220,  221,  225,  105,   42,
 /*   280 */    43,  111,  143,  144,  170,   20,   19,   22,  149,   50,
 /*   290 */    23,  218,  156,  220,  221,  156,  170,  171,   61,   62,
 /*   300 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   310 */    73,  238,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   320 */    83,   84,   16,  148,  148,   20,  190,   21,  148,  190,
 /*   330 */   148,  156,   90,  157,  158,   93,   94,   95,  202,  203,
 /*   340 */    19,  148,  103,  207,   23,  170,  171,  105,   42,   43,
 /*   350 */   170,  171,  170,  171,  215,   88,   89,  181,  182,   19,
 /*   360 */    20,  148,   22,  170,  171,  190,  148,   61,   62,   63,
 /*   370 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   380 */   241,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   390 */    84,   16,  148,  213,   12,  213,   21,  148,  154,  191,
 /*   400 */    60,  157,  158,  210,  211,  225,   24,  225,   23,   88,
 /*   410 */    89,   20,  107,   22,  109,  110,   22,   42,   43,   37,
 /*   420 */   148,   39,   20,   19,   20,  187,   22,   20,   18,  157,
 /*   430 */   158,   49,  183,  156,   16,  148,   61,   62,   63,   64,
 /*   440 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  148,
 /*   450 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   460 */    42,   43,   44,   20,   60,   22,   56,  190,  165,  166,
 /*   470 */   167,  170,  171,   88,   89,  107,  227,  109,  110,   61,
 /*   480 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   490 */    72,   73,  215,   75,   76,   77,   78,   79,   80,   81,
 /*   500 */    82,   83,   84,   16,   94,  148,   81,   20,  114,  107,
 /*   510 */   161,  109,  110,  236,  107,  193,  109,  110,  148,  170,
 /*   520 */   148,   23,  200,  166,  167,   23,  225,  168,  169,   42,
 /*   530 */    43,  228,  148,  108,   79,   80,  177,  112,  177,  178,
 /*   540 */   170,  171,  170,  171,  134,  184,   16,   16,   61,   62,
 /*   550 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   560 */    73,  148,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   570 */    83,   84,   42,   43,   43,  100,  101,  102,   14,   81,
 /*   580 */   169,  211,   91,   92,   23,  228,   88,   89,  177,  217,
 /*   590 */    88,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,  148,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   22,  148,   53,   16,   55,
 /*   620 */   148,  151,   20,   20,  148,   22,   20,   23,   22,  148,
 /*   630 */    99,  148,   20,  148,   22,  104,  148,  108,  170,  171,
 /*   640 */   227,  112,  170,  171,   42,   43,  170,  171,  148,   88,
 /*   650 */    89,  170,  171,  170,  171,  170,  171,  148,  170,  171,
 /*   660 */   148,   16,  132,   61,   62,   63,   64,   65,   66,   67,
 /*   670 */    68,   69,   70,   71,   72,   73,  115,   75,   76,   77,
 /*   680 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  217,
 /*   690 */   222,   98,   88,   89,   14,  183,  226,  148,  134,  148,
 /*   700 */   230,  148,  148,   20,   16,   22,   61,   62,   63,   64,
 /*   710 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  115,
 /*   720 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   730 */    42,   43,  183,   53,  183,   55,   20,  183,   22,  227,
 /*   740 */    51,   52,  189,   16,  162,  163,  164,   16,  148,   61,
 /*   750 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   760 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   770 */    82,   83,   84,   42,   43,   43,  227,   19,  227,   19,
 /*   780 */   148,  227,   27,   23,  170,  171,    0,    1,    2,   34,
 /*   790 */    16,  148,  239,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   83,   84,   42,   43,   21,   92,
 /*   820 */    23,  100,  101,  102,    7,    8,    9,  170,  171,  125,
 /*   830 */   126,   99,   20,  131,   22,  133,  146,   63,   64,   65,
 /*   840 */    66,   67,   68,   69,   70,   71,   72,   73,   88,   75,
 /*   850 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   860 */    17,   20,   19,   22,    7,    8,   23,   19,  148,   21,
 /*   870 */   148,  113,  148,  156,   31,  142,  111,  148,  145,  156,
 /*   880 */    20,  204,   22,   16,   17,   88,   19,   42,   43,  124,
 /*   890 */    23,   48,  170,  171,  170,  171,  148,  162,   31,  170,
 /*   900 */   171,  111,   59,  233,  148,  148,  156,  190,  232,   64,
 /*   910 */    65,  148,  148,  190,  124,   48,  148,  156,  170,  171,
 /*   920 */   148,  148,   79,   80,   81,  148,   59,  170,  171,  209,
 /*   930 */    87,   88,   89,  170,  171,   92,  201,   92,  170,  171,
 /*   940 */   190,  148,  170,  171,  148,  189,   79,   80,   20,   22,
 /*   950 */    22,  190,  148,  189,   87,   88,   89,  179,  148,   92,
 /*   960 */   242,  243,  148,  179,  148,  162,  170,  171,  125,  126,
 /*   970 */   127,  128,  129,  130,  170,  171,   16,   17,  111,   19,
 /*   980 */   170,  171,  189,   23,  170,  171,  170,  171,  148,  195,
 /*   990 */   148,   31,  125,  126,  127,  128,  129,  130,  148,  148,
 /*  1000 */   148,  148,  148,  148,  148,  179,  148,  148,   48,  148,
 /*  1010 */   170,  171,  170,  171,  148,  192,   89,  202,  203,   59,
 /*  1020 */   170,  171,  170,  171,  170,  171,  170,  171,  170,  171,
 /*  1030 */   148,  170,  171,  148,  148,  244,  245,  148,  148,   79,
 /*  1040 */    80,  148,  115,  148,  189,  148,  148,   87,   88,   89,
 /*  1050 */   148,  148,   92,    5,  148,  170,  171,  148,   10,   11,
 /*  1060 */    12,   13,  209,  170,  171,  170,  171,  170,  171,  148,
 /*  1070 */   148,  148,  148,  214,   26,  189,   28,  148,  189,  189,
 /*  1080 */   214,  148,  148,   35,  148,  125,  126,  127,  128,  129,
 /*  1090 */   130,  170,  171,  170,  171,   47,  148,   49,  148,  170,
 /*  1100 */   171,  148,   54,  170,  171,   57,  170,  171,  173,  148,
 /*  1110 */   148,  209,  148,  189,  148,  148,  186,  187,  170,  171,
 /*  1120 */   148,  148,  148,  148,  148,  148,  174,  195,  173,  229,
 /*  1130 */   173,  224,  178,  229,  192,  194,  173,  150,  173,   40,
 /*  1140 */   122,  195,  138,  131,   97,  240,   19,  113,  100,  101,
 /*  1150 */   102,  180,  212,  175,  106,  153,  153,   33,   15,  111,
 /*  1160 */   223,  212,  237,  152,  119,  196,  161,   23,  117,  120,
 /*  1170 */   212,   99,    6,  205,  121,  237,  197,  147,  198,  153,
 /*  1180 */   199,  161,  212,  135,   19,  185,  180,   61,  147,  195,
 /*  1190 */    99,  172,   15,   98,  195,  188,  188,  188,  216,  174,
 /*  1200 */   172,  216,  185,  153,  147,  153,  185,  172,  172,  116,
 /*  1210 */   172,  153,  152,  131,  172,  205,   38,  153,  235,  206,
 /*  1220 */   234,  206,  153,  153,  147,   22,  153,  190,  153,  175,
 /*  1230 */   246,  172,  231,  155,  160,  243,   14,  176,  176,    1,
 /*  1240 */    20,   44,   19,   19,  123,  103,   20,  114,  113,  113,
 /*  1250 */    17,   14,  123,  108,  116,  114,   69,   69,   19,  103,
 /*  1260 */     1,   92,   44,   19,   19,    5,   20,   19,  134,   99,
 /*  1270 */    19,   22,   45,   45,   19,   44,   19,   96,   36,   99,
 /*  1280 */   104,   17,   21,   16,  113,   20,  113,   19,   19,    4,
 /*  1290 */    20,   20,  113,  118,   22,   22,   20,   22,   32,   20,
 /*  1300 */   118,   20,    3,   19,   11,   19,  247,  247,   58,  137,
 /*  1310 */   136,
};
#define YY_SHIFT_USE_DFLT (-81)
#define YY_SHIFT_MAX 382
static const short yy_shift_ofst[] = {
 /*     0 */   253,  867, 1048,  -16,  867,  960,  960,  960,  173,   44,
 /*    10 */   418,  960,  960,  960,  960,  960,  -46,  127,  170,  385,
 /*    20 */   455,  502,  455,   53,  602,  237,  306,  530,   96,  487,
 /*    30 */   168,  375,  645,  645,  688,  645,  645,  645,  645,  645,
 /*    40 */   645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
 /*    50 */   645,  731,  774,  774,  843,  960,  960,  960,  960,  960,
 /*    60 */   960,  960,  960,  960,  960,  960,  960,  960,  960,  960,
 /*    70 */   960,  960,  960,  960,  960,  960,  960,  960,  960,  960,
 /*    80 */   960,  960,  960,  960,  960,  960,  960,  960,  960,  960,
 /*    90 */   960,  960,  960,  -62,  -62,    1,   -4,    1,   61,  531,
 /*   100 */   410,  -80,  385,  385,  385,  385,  385,  385,  385,  502,
 /*   110 */    86,  -81,  -81,  -81,  133,    9,  382,  382,  340,  404,
 /*   120 */   385,  385,  385,  385,  797,  385,  385,  385,  385,  385,
 /*   130 */   385,  385,  385,  385,  797,  385,  786,  765,  790,   44,
 /*   140 */    44,   44,  -81,  -81,  -81,  242,  -18,  -18,   92,  407,
 /*   150 */   402,  321,  267,  305,  181,  604,  498,  561,  385,  368,
 /*   160 */   385,  385,  385,  385,  385,  385,  927,  385,  239,  385,
 /*   170 */   368,  385,  385,  721,   69,  385,  368,  239,  385,  368,
 /*   180 */   385,  239,  368,  817,  368,  385,  927,  385,  760,  385,
 /*   190 */   385,  385,  385,  368,  385,  385,  385,  385,  385,  385,
 /*   200 */   385,  385,  425,  385,  105,  593,  755,  105,  755,  704,
 /*   210 */   755,  702,  704,  732,  529,  394,  755,  755,  848, 1099,
 /*   220 */  1018, 1004, 1012, 1047, 1127, 1034, 1034, 1124, 1047, 1143,
 /*   230 */  1045, 1144, 1049, 1051, 1124, 1047, 1072, 1053, 1047, 1166,
 /*   240 */  1034, 1144, 1165, 1099, 1126, 1166, 1018, 1091, 1177, 1177,
 /*   250 */  1177, 1095, 1034, 1018, 1091, 1165, 1126, 1034, 1166, 1126,
 /*   260 */  1091, 1091, 1072, 1093, 1034, 1143, 1091, 1091, 1082, 1178,
 /*   270 */  1034, 1093, 1127, 1034, 1034, 1166,   44, 1034, 1034, 1091,
 /*   280 */  1203,  -81,  -81,  -81,  -81,  -81,  -81,  845,  564,  680,
 /*   290 */   475,  603,  443,  265,  391,   91,  606,  689,  612,  491,
 /*   300 */   683,  716,  812,  857,  758,  841,  727,  928,  860,   51,
 /*   310 */   130, 1222, 1238, 1220, 1223, 1224, 1197, 1121, 1142, 1226,
 /*   320 */  1133, 1135, 1136, 1145, 1233, 1138, 1237, 1141, 1239, 1129,
 /*   330 */  1187, 1188, 1156, 1259, 1169, 1218, 1244, 1260, 1246, 1245,
 /*   340 */  1248, 1170, 1134, 1251, 1227, 1249, 1228, 1255, 1231, 1257,
 /*   350 */  1181, 1242, 1180, 1261, 1176, 1264, 1267, 1265, 1171, 1173,
 /*   360 */  1268, 1269, 1179,  -42, 1270, 1271, 1272, 1175, 1273, 1182,
 /*   370 */  1276, 1275, 1266, 1279, 1281, 1285, 1299, 1284, 1286, 1293,
 /*   380 */  1172, 1174, 1250,
};
#define YY_REDUCE_USE_DFLT (-164)
#define YY_REDUCE_MAX 286
static const short yy_reduce_ofst[] = {
 /*     0 */    49,   52,  139,   55,  175,  193,  182,  180,  176,  136,
 /*    10 */    73,  372,  301,  472,  370,  468,  -17,  357,  277,  244,
 /*    20 */   303, -120,  -19,  -67,  -67,  -67,  -67,  -67,  -67,  -67,
 /*    30 */   -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,
 /*    40 */   -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,  -67,
 /*    50 */   -67,  -67,  -67,  -67,  126,  476,  481,  483,  485,  488,
 /*    60 */   614,  657,  722,  724,  729,  748,  757,  763,  768,  772,
 /*    70 */   796,  804,  810,  814,  816,  840,  842,  850,  852,  854,
 /*    80 */   856,  858,  861,  885,  893,  895,  897,  921,  923,  929,
 /*    90 */   933,  936,  948,  -67,  -67,  -67,  359,  -67,  -67,  361,
 /*   100 */   470,  -67,  272,  249,  512,  549,  551,  553,  554,  582,
 /*   110 */   -67,  -67,  -67,  -67,  349,  411,  930, -163,  791,  791,
 /*   120 */   866,  924,  902,  853,  735,  859,  720,  890,  889,  886,
 /*   130 */   855,  793,  764,  756, -104,  413,  733, -150,  717,  723,
 /*   140 */   750,  761,  718,  322,  815,   16,   54,  114,   32,  208,
 /*   150 */   208,  213,  218,  208,  238,  287,  384,  456,  500,  208,
 /*   160 */   509,  600,  632,  643,  384,  773,  677,  777,  778,  851,
 /*   170 */   208,  882,  898,  670,  676,  903,  208,  784,  906,  208,
 /*   180 */   909,  826,  208,  690,  208,  922,  677,  934,  803,  950,
 /*   190 */   953,  961,  962,  208,  964,  966,  967,  972,  973,  974,
 /*   200 */   975,  976,  823,  977,  794,  952,  935,  932,  955,  900,
 /*   210 */   957,  907,  904,  954,  942,  941,  963,  965,  987,  971,
 /*   220 */   946,  905,  937,  940,  978, 1002, 1003,  925,  949, 1011,
 /*   230 */   969, 1005,  979,  980,  938,  958,  968,  981,  970, 1030,
 /*   240 */  1026, 1020,  982, 1006, 1000, 1041,  994, 1019, 1007, 1008,
 /*   250 */  1009, 1025, 1050,  999, 1028,  985, 1017, 1052, 1057, 1021,
 /*   260 */  1035, 1036, 1010, 1013, 1058, 1060, 1038, 1042,  983,  986,
 /*   270 */  1064, 1015, 1054, 1069, 1070, 1077, 1037, 1073, 1075, 1059,
 /*   280 */  1078, 1074, 1001,  992,  984, 1061, 1062,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   587,  813,  890,  702,  890,  890,  813,  813,  890,  706,
 /*    10 */   864,  890,  813,  890,  890,  809,  784,  835,  890,  890,
 /*    20 */   835,  618,  835,  737,  890,  890,  890,  890,  890,  890,
 /*    30 */   890,  890,  745,  805,  890,  718,  806,  739,  735,  804,
 /*    40 */   750,  751,  808,  742,  812,  738,  726,  865,  744,  849,
 /*    50 */   868,  772,  771,  790,  890,  890,  890,  890,  890,  890,
 /*    60 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    70 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    80 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    90 */   890,  890,  890,  795,  774,  783,  611,  773,  775,  671,
 /*   100 */   606,  776,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   110 */   777,  792,  778,  791,  890,  890,  890,  890,  890,  890,
 /*   120 */   890,  890,  890,  890,  702,  890,  890,  890,  890,  890,
 /*   130 */   890,  890,  890,  890,  702,  890,  587,  890,  890,  890,
 /*   140 */   890,  890,  883,  696,  706,  662,  890,  890,  890,  890,
 /*   150 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  856,
 /*   160 */   890,  890,  592,  890,  890,  890,  710,  890,  890,  890,
 /*   170 */   608,  890,  890,  890,  841,  890,  683,  890,  890,  709,
 /*   180 */   890,  890,  747,  594,  685,  823,  704,  890,  620,  890,
 /*   190 */   890,  890,  890,  854,  890,  890,  890,  890,  869,  890,
 /*   200 */   890,  871,  694,  890,  741,  644,  729,  741,  729,  890,
 /*   210 */   729,  807,  890,  641,  694,  703,  729,  729,  890,  658,
 /*   220 */   741,  876,  890,  730,  817,  711,  711,  867,  730,  603,
 /*   230 */   732,  890,  734,  722,  867,  730,  719,  736,  730,  591,
 /*   240 */   711,  890,  752,  658,  675,  591,  741,  673,  682,  682,
 /*   250 */   682,  644,  711,  741,  673,  752,  675,  711,  591,  675,
 /*   260 */   673,  673,  719,  721,  711,  603,  673,  673,  848,  845,
 /*   270 */   711,  721,  817,  711,  711,  591,  890,  711,  711,  673,
 /*   280 */   661,  628,  851,  883,  888,  646,  646,  890,  890,  890,
 /*   290 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   300 */   890,  890,  890,  890,  759,  890,  890,  890,  890,  890,
 /*   310 */   830,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   320 */   890,  760,  764,  688,  890,  890,  890,  890,  890,  890,
 /*   330 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   340 */   890,  890,  890,  890,  890,  844,  843,  890,  890,  890,
 /*   350 */   890,  890,  890,  890,  890,  890,  890,  890,  761,  890,
 /*   360 */   890,  890,  890,  890,  890,  890,  733,  890,  723,  890,
 /*   370 */   890,  890,  890,  890,  890,  890,  588,  890,  878,  890,
 /*   380 */   890,  890,  875,  583,  582,  585,  584,  586,  590,  593,
 /*   390 */   615,  616,  617,  595,  596,  597,  598,  599,  600,  601,
 /*   400 */   607,  609,  627,  629,  636,  674,  677,  678,  679,  859,
 /*   410 */   860,  861,  637,  656,  659,  660,  638,  645,  727,  728,
 /*   420 */   639,  692,  693,  756,  686,  687,  691,  758,  762,  763,
 /*   430 */   765,  766,  614,  621,  622,  625,  626,  831,  833,  832,
 /*   440 */   834,  624,  623,  767,  770,  779,  780,  782,  788,  794,
 /*   450 */   797,  781,  786,  787,  789,  793,  796,  689,  690,  800,
 /*   460 */   802,  803,  857,  858,  798,  810,  811,  712,  801,  785,
 /*   470 */   724,  613,  731,  725,  695,  705,  714,  715,  716,  717,
 /*   480 */   700,  701,  707,  720,  754,  755,  708,  697,  698,  699,
 /*   490 */   799,  757,  768,  769,  640,  647,  648,  649,  652,  653,
 /*   500 */   654,  655,  650,  651,  818,  819,  821,  820,  642,  643,
 /*   510 */   657,  630,  631,  632,  633,  764,  634,  635,  619,  612,
 /*   520 */   663,  666,  667,  668,  669,  670,  672,  664,  665,  610,
 /*   530 */   602,  604,  713,  837,  846,  847,  842,  838,  839,  840,
 /*   540 */   605,  814,  815,  676,  748,  749,  836,  850,  852,  753,
 /*   550 */   853,  855,  880,  680,  681,  684,  822,  862,  740,  743,
 /*   560 */   746,  824,  825,  826,  827,  828,  829,  863,  866,  870,
 /*   570 */   872,  873,  874,  877,  879,  884,  885,  886,  889,  887,
 /*   580 */   589,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "insert_cmd ::= INSERT orconf",
 /* 168 */ "insert_cmd ::= REPLACE",
 /* 169 */ "itemlist ::= itemlist COMMA expr",
 /* 170 */ "itemlist ::= expr",
 /* 171 */ "inscollist_opt ::=",
 /* 172 */ "inscollist_opt ::= LP inscollist RP",
 /* 173 */ "inscollist ::= inscollist COMMA nm",
 /* 174 */ "inscollist ::= nm",
 /* 175 */ "expr ::= term",
 /* 176 */ "expr ::= LP expr RP",
 /* 177 */ "term ::= NULL",
 /* 178 */ "expr ::= ID",
 /* 179 */ "expr ::= JOIN_KW",
 /* 180 */ "expr ::= nm DOT nm",
 /* 181 */ "expr ::= nm DOT nm DOT nm",
 /* 182 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 183 */ "term ::= STRING",
 /* 184 */ "expr ::= REGISTER",
 /* 185 */ "expr ::= VARIABLE",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= exprlist COMMA expritem",
 /* 230 */ "exprlist ::= expritem",
 /* 231 */ "expritem ::= expr",
 /* 232 */ "expritem ::=",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 242 */ "cmd ::= VACUUM",
 /* 243 */ "cmd ::= VACUUM nm",
 /* 244 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 249 */ "cmd ::= PRAGMA nm dbnm",
 /* 250 */ "plus_num ::= plus_opt number",
 /* 251 */ "minus_num ::= MINUS number",
 /* 252 */ "number ::= INTEGER|FLOAT",
 /* 253 */ "plus_opt ::= PLUS",
 /* 254 */ "plus_opt ::=",
 /* 255 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 256 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 257 */ "trigger_time ::= BEFORE",
 /* 258 */ "trigger_time ::= AFTER",
 /* 259 */ "trigger_time ::= INSTEAD OF",
 /* 260 */ "trigger_time ::=",
 /* 261 */ "trigger_event ::= DELETE|INSERT",
 /* 262 */ "trigger_event ::= UPDATE",
 /* 263 */ "trigger_event ::= UPDATE OF inscollist",
 /* 264 */ "foreach_clause ::=",
 /* 265 */ "foreach_clause ::= FOR EACH ROW",
 /* 266 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 267 */ "when_clause ::=",
 /* 268 */ "when_clause ::= WHEN expr",
 /* 269 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 270 */ "trigger_cmd_list ::=",
 /* 271 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 272 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 273 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 274 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 275 */ "trigger_cmd ::= select",
 /* 276 */ "expr ::= RAISE LP IGNORE RP",
 /* 277 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 278 */ "raisetype ::= ROLLBACK",
 /* 279 */ "raisetype ::= ABORT",
 /* 280 */ "raisetype ::= FAIL",
 /* 281 */ "cmd ::= DROP TRIGGER fullname",
 /* 282 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 283 */ "key_opt ::=",
 /* 284 */ "key_opt ::= KEY expr",
 /* 285 */ "database_kw_opt ::= DATABASE",
 /* 286 */ "database_kw_opt ::=",
 /* 287 */ "cmd ::= DETACH database_kw_opt expr",
 /* 288 */ "cmd ::= REINDEX",
 /* 289 */ "cmd ::= REINDEX nm dbnm",
 /* 290 */ "cmd ::= ANALYZE",
 /* 291 */ "cmd ::= ANALYZE nm dbnm",
 /* 292 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 293 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 294 */ "add_column_fullname ::= fullname",
 /* 295 */ "kwcolumn_opt ::=",
 /* 296 */ "kwcolumn_opt ::= COLUMNKW",
 /* 297 */ "cmd ::= create_vtab",
 /* 298 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 299 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 300 */ "vtabarglist ::= vtabarg",
 /* 301 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 302 */ "vtabarg ::=",
 /* 303 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 304 */ "vtabargtoken ::= ANY",
 /* 305 */ "vtabargtoken ::= lp anylist RP",
 /* 306 */ "lp ::= LP",
 /* 307 */ "anylist ::=",
 /* 308 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1248 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 235:
#line 631 "parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1263 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 865 "parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1278 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 502 "parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1286 "parse.c"
      break;
    case 199:
#line 563 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy234).pLimit);
  sqlite3ExprDelete((yypminor->yy234).pOffset);
}
#line 1294 "parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 519 "parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1301 "parse.c"
      break;
    case 231:
    case 236:
#line 959 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1307 "parse.c"
      break;
    case 233:
#line 943 "parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1312 "parse.c"
      break;
    case 238:
#line 1027 "parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1317 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1486 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 7 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 166, 2 },
  { 167, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 144, 5 },
  { 230, 10 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 3 },
  { 144, 6 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 144, 1 },
  { 144, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1873 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1878 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1883 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1888 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1893 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1898 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1907 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1913 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1918 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 1925 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "parse.y"
{yygotominor.yy46 = 0;}
#line 1940 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "parse.y"
{yygotominor.yy46 = 1;}
#line 1952 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 1959 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 1967 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 1975 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 1983 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 252:
#line 168 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 1993 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 1998 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 240:
      case 250:
      case 251:
#line 229 "parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2011 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2019 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2027 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2032 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy46 = atoi((char*)yymsp[0].minor.yy410.z); }
#line 2037 "parse.c"
        break;
      case 45:
#line 243 "parse.y"
{ yygotominor.yy46 = -atoi((char*)yymsp[0].minor.yy410.z); }
#line 2042 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2048 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2053 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2061 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2069 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2074 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2079 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2084 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2089 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2094 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2099 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2104 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2109 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2114 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2119 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2124 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2129 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2134 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2139 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2144 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2149 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2154 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 167:
#line 302 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2165 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2170 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2175 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2180 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2185 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2190 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2198 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2204 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2209 "parse.c"
        break;
      case 98:
      case 168:
#line 344 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2215 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2222 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-5].minor.yy46);
}
#line 2229 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2236 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2244 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2250 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2261 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2266 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2273 "parse.c"
        break;
      case 114:
      case 237:
#line 414 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2279 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 236:
#line 415 "parse.y"
{yygotominor.yy174 = 0;}
#line 2287 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2294 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2301 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2310 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy410.n = 0;}
#line 2315 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2320 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{yygotominor.yy373 = yymsp[0].minor.yy373;}
#line 2325 "parse.c"
        break;
      case 124:
#line 452 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2333 "parse.c"
        break;
      case 125:
#line 456 "parse.y"
{yygotominor.yy373 = 0;}
#line 2338 "parse.c"
        break;
      case 126:
#line 457 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410);
  if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
  if( yymsp[-1].minor.yy172 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
  }
  if( yymsp[0].minor.yy432 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
  }
}
#line 2354 "parse.c"
        break;
      case 127:
#line 471 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-6].minor.yy373,0,0);
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].pSelect = yymsp[-4].minor.yy219;
    if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
    if( yymsp[-1].minor.yy172 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
    }
    if( yymsp[0].minor.yy432 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
    }
  }
#line 2371 "parse.c"
        break;
      case 129:
#line 492 "parse.y"
{
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2378 "parse.c"
        break;
      case 130:
#line 498 "parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2383 "parse.c"
        break;
      case 132:
#line 503 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2388 "parse.c"
        break;
      case 133:
#line 507 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2393 "parse.c"
        break;
      case 134:
#line 508 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2398 "parse.c"
        break;
      case 135:
#line 509 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2403 "parse.c"
        break;
      case 136:
#line 511 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2408 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 175:
      case 202:
      case 225:
      case 227:
      case 231:
#line 515 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2421 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 203:
      case 226:
      case 228:
      case 232:
#line 516 "parse.y"
{yygotominor.yy172 = 0;}
#line 2432 "parse.c"
        break;
      case 139:
      case 172:
#line 520 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2438 "parse.c"
        break;
      case 140:
      case 171:
#line 521 "parse.y"
{yygotominor.yy432 = 0;}
#line 2444 "parse.c"
        break;
      case 142:
      case 152:
#line 532 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2450 "parse.c"
        break;
      case 143:
#line 533 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2458 "parse.c"
        break;
      case 144:
#line 537 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2466 "parse.c"
        break;
      case 146:
      case 148:
#line 546 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2472 "parse.c"
        break;
      case 147:
#line 547 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2477 "parse.c"
        break;
      case 149:
#line 549 "parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2482 "parse.c"
        break;
      case 155:
#line 567 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2487 "parse.c"
        break;
      case 156:
#line 568 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2492 "parse.c"
        break;
      case 157:
#line 570 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2497 "parse.c"
        break;
      case 158:
#line 572 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2502 "parse.c"
        break;
      case 159:
#line 576 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2507 "parse.c"
        break;
      case 162:
#line 587 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);}
#line 2512 "parse.c"
        break;
      case 163:
#line 593 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2517 "parse.c"
        break;
      case 164:
#line 594 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2522 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2527 "parse.c"
        break;
      case 166:
#line 602 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2532 "parse.c"
        break;
      case 169:
      case 229:
#line 612 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2538 "parse.c"
        break;
      case 170:
      case 230:
#line 613 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2544 "parse.c"
        break;
      case 173:
#line 622 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2549 "parse.c"
        break;
      case 174:
#line 623 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2554 "parse.c"
        break;
      case 176:
#line 634 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2559 "parse.c"
        break;
      case 177:
      case 182:
      case 183:
#line 635 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2566 "parse.c"
        break;
      case 178:
      case 179:
#line 636 "parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2572 "parse.c"
        break;
      case 180:
#line 638 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2581 "parse.c"
        break;
      case 181:
#line 643 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2592 "parse.c"
        break;
      case 184:
#line 652 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2597 "parse.c"
        break;
      case 185:
#line 653 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2606 "parse.c"
        break;
      case 186:
#line 659 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2614 "parse.c"
        break;
      case 187:
#line 664 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2625 "parse.c"
        break;
      case 188:
#line 671 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2633 "parse.c"
        break;
      case 189:
#line 675 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ) yygotominor.yy172->op = TK_CONST_FUNC;  
}
#line 2643 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 681 "parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2655 "parse.c"
        break;
      case 198:
      case 200:
#line 691 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2661 "parse.c"
        break;
      case 199:
      case 201:
#line 692 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2667 "parse.c"
        break;
      case 204:
#line 699 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2683 "parse.c"
        break;
      case 205:
#line 712 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2691 "parse.c"
        break;
      case 206:
#line 716 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2699 "parse.c"
        break;
      case 207:
#line 720 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2707 "parse.c"
        break;
      case 208:
#line 724 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2715 "parse.c"
        break;
      case 209:
#line 728 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2723 "parse.c"
        break;
      case 210:
#line 732 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2731 "parse.c"
        break;
      case 211:
#line 736 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2739 "parse.c"
        break;
      case 214:
#line 743 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2755 "parse.c"
        break;
      case 217:
#line 759 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2769 "parse.c"
        break;
      case 218:
#line 769 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2782 "parse.c"
        break;
      case 219:
#line 778 "parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2796 "parse.c"
        break;
      case 220:
#line 788 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2811 "parse.c"
        break;
      case 221:
#line 799 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2824 "parse.c"
        break;
      case 222:
#line 811 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2837 "parse.c"
        break;
      case 223:
#line 822 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2845 "parse.c"
        break;
      case 224:
#line 826 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2853 "parse.c"
        break;
      case 233:
#line 853 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2861 "parse.c"
        break;
      case 234:
      case 279:
#line 859 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2867 "parse.c"
        break;
      case 235:
#line 860 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 2872 "parse.c"
        break;
      case 238:
#line 870 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2885 "parse.c"
        break;
      case 239:
#line 879 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2898 "parse.c"
        break;
      case 241:
#line 893 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2903 "parse.c"
        break;
      case 242:
      case 243:
#line 897 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2909 "parse.c"
        break;
      case 244:
      case 246:
#line 903 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 2915 "parse.c"
        break;
      case 245:
#line 904 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 2920 "parse.c"
        break;
      case 247:
#line 906 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 2927 "parse.c"
        break;
      case 248:
#line 909 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 2932 "parse.c"
        break;
      case 249:
#line 910 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 2937 "parse.c"
        break;
      case 255:
#line 922 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 2947 "parse.c"
        break;
      case 256:
#line 931 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[-1].minor.yy46, yymsp[0].minor.yy172, yymsp[-9].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 2955 "parse.c"
        break;
      case 257:
      case 260:
#line 937 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 2961 "parse.c"
        break;
      case 258:
#line 938 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 2966 "parse.c"
        break;
      case 259:
#line 939 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 2971 "parse.c"
        break;
      case 261:
      case 262:
#line 944 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 2977 "parse.c"
        break;
      case 263:
#line 946 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 2982 "parse.c"
        break;
      case 264:
      case 265:
#line 949 "parse.y"
{ yygotominor.yy46 = TK_ROW; }
#line 2988 "parse.c"
        break;
      case 266:
#line 951 "parse.y"
{ yygotominor.yy46 = TK_STATEMENT; }
#line 2993 "parse.c"
        break;
      case 267:
#line 955 "parse.y"
{ yygotominor.yy172 = 0; }
#line 2998 "parse.c"
        break;
      case 268:
#line 956 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3003 "parse.c"
        break;
      case 269:
#line 960 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3016 "parse.c"
        break;
      case 270:
#line 969 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3021 "parse.c"
        break;
      case 271:
#line 975 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3026 "parse.c"
        break;
      case 272:
#line 980 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3031 "parse.c"
        break;
      case 273:
#line 983 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3036 "parse.c"
        break;
      case 274:
#line 987 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3041 "parse.c"
        break;
      case 275:
#line 990 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3046 "parse.c"
        break;
      case 276:
#line 993 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3057 "parse.c"
        break;
      case 277:
#line 1000 "parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3068 "parse.c"
        break;
      case 278:
#line 1010 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3073 "parse.c"
        break;
      case 280:
#line 1012 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3078 "parse.c"
        break;
      case 281:
#line 1017 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373);
}
#line 3085 "parse.c"
        break;
      case 282:
#line 1023 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3092 "parse.c"
        break;
      case 283:
#line 1028 "parse.y"
{ yygotominor.yy386 = 0; }
#line 3097 "parse.c"
        break;
      case 284:
#line 1029 "parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3102 "parse.c"
        break;
      case 287:
#line 1035 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3109 "parse.c"
        break;
      case 288:
#line 1041 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3114 "parse.c"
        break;
      case 289:
#line 1042 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3119 "parse.c"
        break;
      case 290:
#line 1047 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3124 "parse.c"
        break;
      case 291:
#line 1048 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3129 "parse.c"
        break;
      case 292:
#line 1053 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3136 "parse.c"
        break;
      case 293:
#line 1056 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3143 "parse.c"
        break;
      case 294:
#line 1059 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3150 "parse.c"
        break;
      case 297:
#line 1068 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3155 "parse.c"
        break;
      case 298:
#line 1069 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3160 "parse.c"
        break;
      case 299:
#line 1070 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3167 "parse.c"
        break;
      case 302:
#line 1075 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3172 "parse.c"
        break;
      case 304:
      case 305:
      case 306:
      case 308:
#line 1077 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3180 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3248 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
