/* 
 * $Id: ctkstack.c,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

GNode **focus_stack = NULL;

/* Get Number of items in stack */
gint stack_num_items(GNode **stack)
{
	gint i;

	if (!stack)
	    return 0;
	
	for (i = 0; stack[i]; i += 1)
	{
		// noop
	}

	return i;
}

/* Push an item onto the stack */
gint stack_push(GNode *node)
{
	gint num_items;
	gint i;
	
	if (!node) {
		ctk_close();
		g_error("stack_push: GNode *node == NULL!");
	}
	
	if (focus_stack == NULL)
	{
		focus_stack = g_malloc(sizeof(GNode *));
		focus_stack[0] = NULL;
	}

	num_items = stack_num_items(focus_stack);
	
	focus_stack = realloc(focus_stack,
			      sizeof(GNode *)*(num_items+2));

	focus_stack[num_items+1] = NULL;
	
	for (i = num_items; i > 0; i -= 1)
	{
		focus_stack[i] = focus_stack[i-1];
	}
	
	focus_stack[0] = node;

	return 1;
}

/* Check if an item exists in the stack */
gint stack_item_exist(GNode *node)
{
	gint i;
	
	if (!node)
	{
		ctk_close();
		g_error("stack_item_exist: GNode *node == NULL!");
	}
	
	if (!focus_stack)
	    return 0;
	
	for (i = 0; focus_stack[i]; i += 1)
	{
		if (focus_stack[i] == node)
		    return 1;
	}
	
	return 0;
}

/* Pop an item from the stack.
 * It may not necessarily be from the top either. */
gint stack_pop(GNode *node)
{
	gint i;
	
	if (!node)
	{
		ctk_close();
		g_error("stack_pop: GNode *node == NULL!");
	}
	
	if (!focus_stack)
	    return 0;
	
	for (i = 0; focus_stack[i]; i += 1)
	{
		if (focus_stack[i] == node)
		    break;
	}
		
	if (!focus_stack[i])
	    return 0;
	
	for (i += 1; focus_stack[i]; i += 1) {
		focus_stack[i-1] = focus_stack[i];
	}
	
	focus_stack[i-1] = NULL;

	return 1;
}
