#ifndef CTK_ASSERT_H
#define CTK_ASSERT_H

/* To use a ctk assertions: 
 *  ctk_assert(ptr != NULL, "Null window passed!");
 *  ctk_assert_not_reached("This should never happen!");
 */

/* Ctk assertions are very handy, there are three modes:
 *  -DNDEBUG or -DNODEBUG: ignore assertions (final release - fast)
 *  -DSILENT_FAIL:         failed assertions leave the function silently
 *  normally:              Opens a window with the name of the asserting
 *                         function, line, and source file, and the assertion
 *                         that failed. Plus an optional programmer message.
 *
 *                         User can ignore, return, dump core
 */

/* We use the nice names provided by newer gccs if we can */
#ifdef __GNUC__
#if __GNUC__ > 2 || (__GNUC__ == 2 \
			&& __GNUC_MINOR__ >= (defined __cplusplus ? 6 : 4))
#define CTK_ASSERT_CALLER __PRETTY_FUNCTION__
#else
#define CTK_ASSERT_CALLER ((const gchar*)0)
#endif
#else
#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#define CTK_ASSERT_CALLER __func__
#else
#define CTK_ASSERT_CALLER ((const gchar*)0)
#endif
#endif

/* Choose behaviour by -D options */
#if defined(NDEBUG) || defined(NODEBUG)
/* Do not do anything with assertions */
#define ctk_assert_lie(exp, mess, file, line, func) ((void)0)
#else

#ifdef SILENT_FAIL
/* If you want to just quit routines silently that fail assertions, do this */

/* FIXME: doesn't return - needs a stack hack for later */
#define ctk_assert_lie(exp, mess, file, line, func) ((void)0)

#else

/* Return values: 0 - return from function
 *                1 - continue past assertion
 *                2 - dump core
 */
int ctk_assertion_failed(const gchar* assertion, const gchar* reason, 
			const char* file, gint line, const gchar* func);
			
/* This is the normal assertion routine */
#define ctk_assert_lie(exp, mess, file, line, func) \
	( \
		((exp) ? 0 : \
			(ctk_assertion_failed(#exp, mess, file, line, func) \
				== 2) \
			? abort() : 0) \
	)
/* FIXME: return is unimplemented */
	
#endif /* SILENT_FAIL */
#endif /* NDEBUG / NODEBUG */

#define ctk_assert(exp, mess) ctk_assert_lie((exp), mess, \
					__FILE__, __LINE__, CTK_ASSERT_CALLER)
#define CTK_ASSERT_NOT_REACHED	0
#define ctk_assert_not_reached(mess) ctk_assert_lie(CTK_ASSERT_NOT_REACHED, mess, \
					__FILE__, __LINE__, CTK_ASSERT_CALLER)
#endif
