/* 
 * $Id: ctkassert.c,v 1.4 2000/07/12 04:01:04 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <unistd.h>
#include "ctk.h"

static void button_clicked(CtkButton* button, gboolean* toggle)
{
	*toggle = TRUE;
	ctk_main_quit();
}

int ctk_assertion_failed(const gchar* assertion, const gchar* message, 
			const gchar* file, gint line, const gchar* caller)
{
	CtkWindow*    window;
	CtkEntry*     directory;
	CtkSeparator* separator;
	CtkBox*       vbox;
	CtkBox*       dirrow;
	CtkBox*       hbox;
	CtkButton*    ignore;
	CtkButton*    dumpcore;
	CtkButton*    exit;
	CtkLabel*     location;
	CtkTable*     table;
	CtkLabel*     assert1;
	CtkLabel*     assert2;
	CtkLabel*     reason1;
	CtkLabel*     reason2;
	CtkLabel*     core;
	gboolean      ignore_hit;
	gboolean      dumpcore_hit;
	gboolean      exit_hit;
	gchar*        text;
	GNode**       save_stack;
	
	/* NOTE: do not use CTK_WINDOW() or such b/c this might cause
	 * another assertion failure!
	 */
	
	save_stack = focus_stack;
	focus_stack = (GNode**)0;
	
	window = (CtkWindow*)ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_show((CtkWidget*)window);
	ctk_widget_set_usize((CtkWidget*)window, 70, 12);
	ctk_window_set_title(window, "Assertion failed");
	ctk_window_set_autocenter(window, TRUE);
	ctk_window_set_policy(window, FALSE, FALSE, FALSE);
	window->OPTIONS_MASK &= ~WINMASK_CLOSABLE; /* remove the 'x' */
	
	ctk_window_set_modal(window, TRUE);
	
	vbox = (CtkBox*)ctk_vbox_new(FALSE, 0);
	ctk_widget_show((CtkWidget*)vbox);
	ctk_container_add((CtkContainer*)window, (CtkWidget*)vbox);
	ctk_container_set_border_width((CtkContainer*)vbox, 1);
	
	if (caller)
	{
		location = (CtkLabel*)
			ctk_label_newf("In %s:%i:%s:\n", file, line, caller);
	}
	else
	{
		location = (CtkLabel*)
			ctk_label_newf("In %s:%i:\n", file, line);
	}
	ctk_widget_show((CtkWidget*)location);
	ctk_label_set_justify(location, CTK_JUSTIFY_LEFT);
	ctk_box_pack_start(vbox, (CtkWidget*)location, FALSE, TRUE, 0);
	
	table = (CtkTable*)ctk_table_new(2, 2, FALSE);
	ctk_widget_show((CtkWidget*)table);
	ctk_box_pack_start(vbox, (CtkWidget*)table, FALSE, TRUE, 0);
	
	assert1 = (CtkLabel*)ctk_label_new("Assertion: ");
	ctk_misc_set_alignment((CtkMisc*)assert1, 0, 0);
	ctk_widget_show((CtkWidget*)assert1);
	ctk_table_attach(table, (CtkWidget*)assert1, 0, 1, 0, 1, 
		CTK_FILL, CTK_FILL, 0, 0);
	
	assert2 = (CtkLabel*)ctk_label_new(assertion);
	ctk_label_set_justify(assert2, CTK_JUSTIFY_LEFT);
	ctk_label_set_line_wrap(assert2, TRUE);
	ctk_widget_show((CtkWidget*)assert2);
	ctk_table_attach(table, (CtkWidget*)assert2, 1, 2, 0, 1, 
		CTK_FILL|CTK_EXPAND, CTK_FILL, 0, 0);
	
	reason1 = (CtkLabel*)ctk_label_new("Reason: ");
	ctk_misc_set_alignment((CtkMisc*)reason1, 0, 0);
	ctk_widget_show((CtkWidget*)reason1);
	ctk_table_attach(table, (CtkWidget*)reason1, 0, 1, 1, 2, 
		CTK_FILL, CTK_FILL, 0, 0);
	
	reason2 = (CtkLabel*)ctk_label_new(message);
	ctk_label_set_justify(reason2, CTK_JUSTIFY_LEFT);
	ctk_label_set_line_wrap(reason2, TRUE);
	ctk_widget_show((CtkWidget*)reason2);
	ctk_table_attach(table, (CtkWidget*)reason2, 1, 2, 1, 2, 
		CTK_FILL|CTK_EXPAND, CTK_FILL, 0, 0);
	
	separator = (CtkSeparator*)ctk_hseparator_new();
	ctk_widget_show((CtkWidget*)separator);
	ctk_box_pack_start(vbox, (CtkWidget*)separator, FALSE, TRUE, 1);
	
	hbox = (CtkBox*)ctk_hbox_new(FALSE, 0);
	ctk_widget_show((CtkWidget*)hbox);
	ctk_box_pack_start(vbox, (CtkWidget*)hbox, FALSE, TRUE, 0);
	
	ignore = (CtkButton*)ctk_button_new_with_label(" Ignore ");
	ctk_widget_show((CtkWidget*)ignore);
	ctk_box_pack_start(hbox, (CtkWidget*)ignore, TRUE, FALSE, 0);
	
	exit = (CtkButton*)ctk_button_new_with_label(" Return ");
	ctk_widget_show((CtkWidget*)exit);
	ctk_box_pack_start(hbox, (CtkWidget*)exit, TRUE, FALSE, 0);
	
	dumpcore = (CtkButton*)ctk_button_new_with_label(" Dump Core ");
	ctk_widget_show((CtkWidget*)dumpcore);
	ctk_box_pack_start(hbox, (CtkWidget*)dumpcore, TRUE, FALSE, 0);
	
	dirrow = (CtkBox*)ctk_hbox_new(FALSE, 1);
	ctk_widget_show((CtkWidget*)dirrow);
	ctk_box_pack_start(vbox, (CtkWidget*)dirrow, FALSE, TRUE, 0);
	
	core = (CtkLabel*)ctk_label_new("Core dir:");
	ctk_widget_show((CtkWidget*)core);
	ctk_box_pack_start(dirrow, (CtkWidget*)core, FALSE, TRUE, 0);
	
	directory = (CtkEntry*)ctk_entry_new();
	ctk_entry_set_text(directory, ".");
	ctk_widget_show((CtkWidget*)directory);
	ctk_box_pack_start(dirrow, (CtkWidget*)directory, TRUE, TRUE, 0);
	
	ctk_window_set_focus(window, (CtkWidget*)ignore);
	
	ignore_hit   = FALSE;
	dumpcore_hit = FALSE;
	exit_hit     = FALSE;
	
	ctk_signal_connect((CtkObject*)ignore, "clicked",
		CTK_SIGNAL_FUNC(&button_clicked), &ignore_hit);
	ctk_signal_connect((CtkObject*)dumpcore, "clicked",
		CTK_SIGNAL_FUNC(&button_clicked), &dumpcore_hit);
	ctk_signal_connect((CtkObject*)exit, "clicked",
		CTK_SIGNAL_FUNC(&button_clicked), &exit_hit);
	
	ctk_main();
	
	ctk_widget_destroy((CtkWidget*)window);
	
	focus_stack = save_stack;
	
	if (exit_hit)   return 0;
	if (ignore_hit) return 1;
	
	/* dumpcore_hit is TRUE */
	text = ctk_entry_get_text(directory);
	if (text && *text) chdir(text);
	
	return 2;
}
