#include <coveb.h>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>

double get_doubletime(void)
{
  double rv;
  struct timeval tv;
  struct timezone tz;
  gettimeofday(&tv, &tz);
  rv = tv.tv_sec * 1.0 + tv.tv_usec * 1e-6;
  return rv;
}

void test_mqueue(struct coveb_mq *q);

void test_01_mqueue(void)
{
  struct coveb_mq *q;
  q = coveb_mq_new(32);
  struct vEBMPDatum c,o;
  c._x = 5;
  c._p._pl[0] = 7;
  if (coveb_mq_contains(q,5) != 0)
    coveb_failout("should not contain 5");
  coveb_mq_insert(q,c);
  if (!coveb_mq_contains(q,5) != 0)
    coveb_failout("should contain 5");
  o = coveb_mq_min(q);
  if (o._x != 5)
    coveb_failout("min is not 5");
  if (o._p._pl[0] != 7)
    coveb_failout("payload is not 7");
  c._p._pl[0] = 6;
  coveb_mq_insert(q,c);
  o = coveb_mq_min(q);
  if (o._x != 5)
    coveb_failout("min is not 5");
  if (o._p._pl[0] != 6)
    coveb_failout("payload is not 6");
  c._p._pl[0] = 13;
  c._x = 3;
  coveb_mq_insert(q,c);
  o = coveb_mq_min(q);
  if (o._x != 3)
    coveb_failout("min is not 3");
  if (o._p._pl[0] != 13)
    coveb_failout("payload is not 13");
  uint32_t gr;
  coveb_mq_locate_smallest_not_less_than(q, 4, &o, &gr);
  if (o._x != 5)
    coveb_failout("locate min is not 5");
  if (o._p._pl[0] != 6) {
    printf("Locate payload was %d\n", o._p._pl[0]);
    coveb_failout("locate payload is not 6");
  }
}

void test_02_mqueue(struct coveb_mq *q);

void test_mqueue(struct coveb_mq *q)
{
  test_02_mqueue(q);
}

void test_02_mqueue(struct coveb_mq *q)
{
//  const unsigned long long wantresult = 555422495824047LL;
//  const unsigned long wantsize = 123;
  printf("Verifying class coveb_mq\n");
  const int REPS = 1000000;
  //const int STARTSEED = 0;
  //double t0, tf;
  int i;
  long long acc = 0;
  uint32_t currand = 0;
  for (i = 0; i < REPS; i += 1) {
    currand = ((currand * currand) + 3 * currand + 17) % 0x7113ff17;
    if (currand % 555 < 2) {
      struct coveb_mq *q2;
      q2 = coveb_mq_clone(q);
//      printf("Cloning size %d and %d\n", coveb_mq_size(q), coveb_mq_size(q2));
      assert(coveb_mq_size(q) == coveb_mq_size(q2));
      coveb_mq_free(q);
      q = q2;
    }
    if (coveb_mq_size(q) > 1 && currand % 5 < 2) {
      struct vEBMPDatum da;
      da = coveb_mq_extractmin(q);
      int nmv = da._x;
//      printf("extracted nmv: %d and %d\n", nmv, da._p._pl[0]);
      if (da._x % 777 != da._p._pl[0]) {
        printf("expected %d and %d\n", da._x, da._x % 777);
        coveb_failout("payload retrieve error");
      }
      acc += nmv;
    }
    else {
      COVEB_KEYTYPE r = currand >> 2;
      currand = ((currand * currand) + 23 - 18 * currand) % 0x70173f37;
      r ^= currand;
      struct vEBMPDatum d;
      d._x = r;
      d._p._pl[0] = r % 777;
//      printf("Inserted %d and pl %d\n", d._x, d._p._pl[0]);
      coveb_mq_insert(q,d);
      assert(coveb_mq_contains(q,r));
      coveb_mq_max(q);
    }
  }
/*
  if (acc != wantresult) {
    printf("Error: Wanted result %lld but got %lld\n", wantresult, acc);
    exit(1);
  }
  if (coveb_mq_size(q) != wantsize) {
    printf("Error: Wanted size %d but got %d\n", wantsize, coveb_mq_size(q));
    exit(1);
  }
*/
//  printf("endsize: %d\n", coveb_mq_size(q));
}

void test_queue(struct coveb_bq *q)
{
  const unsigned long long wantresult = 555422495824047LL;
  const unsigned long wantsize = 123;
  printf("Verifying class coveb_pq\n");
  const int REPS = 1000000;
  //const int STARTSEED = 0;
  //double t0, tf;
  int i;
  long long acc = 0;
  uint32_t currand = 0;
  for (i = 0; i < REPS; i += 1) {
    currand = ((currand * currand) + 17) % 0x7fffff17;
    if (coveb_bq_size(q) > 1 && currand % 5 < 2) {
      int nmv = coveb_bq_extractmin(q);
//      printf("extracted nmv: %d\n", nmv);
      acc += nmv;
    }
    else {
      COVEB_KEYTYPE r = currand >> 2;
      currand = ((currand * currand) + 23 - 18 * currand) % 0x7fffff37;
      r ^= currand;
      coveb_bq_insert(q,r);
      assert(coveb_bq_contains(q, r));
      coveb_bq_max(q);
    }
  }
  if (acc != wantresult) {
    printf("Error: Wanted result %lld but got %lld\n", wantresult, acc);
    exit(1);
  }
  if (coveb_bq_size(q) != wantsize) {
    printf("Error: Wanted size %lu but got %d\n", wantsize, coveb_bq_size(q));
    exit(1);
  }
//  printf("endsize: %d\n", coveb_bq_size(q));
}

void benchmark(struct coveb_bq *q)
{
  printf("Testing class coveb_pq\n");
//  const int REPS = 800000000;
//  const int REPS =   200000000;
  const int REPS = 1000000;
//  const int RANGE = MAXLONG;
  double t0, tf;
  int i;
  long long acc = 0;
  uint32_t currand = 0;
  t0 = get_doubletime();
  for (i = 0; i < REPS; i += 1) {
    currand = ((currand * currand) + 17) % 0x7fffff17;
    if (coveb_bq_size(q) > 1 && currand % 5 < 2) {
      int nmv = coveb_bq_extractmin(q);
//      printf("extracted nmv: %d\n", nmv);
      acc += nmv;
    }
    else {
      COVEB_KEYTYPE r = currand >> 2;
      currand = ((currand * currand) + 23 - 18 * currand) % 0x7fffff37;
      r ^= currand;
      coveb_bq_insert(q,r);
      assert(coveb_bq_contains(q,r));
      coveb_bq_max(q);
    }
  }
  tf = get_doubletime();
  double dt = tf - t0;
  printf("reps: %d\n", REPS);
  printf("acc: %lld\n", acc);
  printf("dt: %f\n", dt);
  printf("endsize: %d\n", coveb_bq_size(q));
  printf("reps/sec: %d\n", (int) (REPS / dt));
}

int main(int argc, char **argv)
{
  printf("Starting libcoveb project.\n");
  struct coveb_bq *q = coveb_bq_new();
  struct coveb_mq *mq = coveb_mq_new(16);
  benchmark(q);
  test_queue(q);
  test_mqueue(mq);
  return 0;
}
