/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

#if   !defined(__OBJECTFACTORY_HPP)
#include <ObjectFactory.hpp>
#endif

using namespace corelinux;

CORELINUX_MAP(  DwordIdentifier,  ObjectPtr,  less<DwordIdentifier> ,  ObjectMap );

DwordIdentifier  ObjectFactory::theCurrentIdentifier(0);

static   ObjectMap   gObjects;

//
// Default constructor
//

ObjectFactory::ObjectFactory( void )
{
   ;  // won't ever get here
}

//
// Copy constructor
//

ObjectFactory::ObjectFactory( ObjectFactoryCref )
{
   ;  // won't ever get here
}

//
// Destructor
//

ObjectFactory::~ObjectFactory( void )
{
   ;  // no instance no cry
}

//
// Assignment operator
//

ObjectFactoryRef  ObjectFactory::operator=( ObjectFactoryCref )
{
   return (*this);   // won't happen
}

//
// Equality operator
//

bool  ObjectFactory::operator==( ObjectFactoryCref ) const
{
   return false;
}

//
// Creates a new identifier
//

DwordIdentifier  ObjectFactory::getNewIdentifier( void )
{
   return (++theCurrentIdentifier);
}

//
// Creates a object, or returns the existing one
//

ObjectCref  ObjectFactory::createObject( DwordIdentifier aIdentifier )
{
   ObjectPtr   aObject( NULLPTR );
   
   ObjectMapIterator fItr( gObjects.find( aIdentifier ) );

   if( fItr == gObjects.end() )
   {
      DwordIdentifier  aId( aIdentifier );
      aObject = new Object( aId );
      gObjects[aId] = aObject;
   }
   else
   {
      aObject = (*fItr).second;
   }

   return (*aObject);
}

//
// Destroys an existing object if it is cached
//

void  ObjectFactory::destroyObject( DwordIdentifier aIdentifier )
{
   ObjectMapIterator fItr( gObjects.find( aIdentifier ) );
   if( fItr != gObjects.end() )
   {
      delete (*fItr).second;
      gObjects.erase( fItr );
   }
   else
   {
      //
      // Depending on whether this is acting as a cache
      // or fully ephemeral the missing object does not
      // mean an error. If you want it to, uncomment
      // the last line
      //
      // NEVER_GET_HERE;
   }
}

//
// Destroys ALL the objects
//

void  ObjectFactory::destroyAllObjects( void )
{
   ObjectMapIterator begin( gObjects.begin() );
   ObjectMapIterator end( gObjects.end() );

   while( begin != end )
   {
      delete (*begin).second;
      ++begin;
   }

   gObjects.erase(gObjects.begin(),end);

}

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.3 $
   $Date: 2000/08/31 22:47:57 $
   $Locker:  $
*/

