/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

 #include "libcdg123.h"
 
 int cdgScrollPreset(struct cdgStream *stream, struct cdgScrollStruct *data) {

	int hscmd, hsoff, vscmd, vsoff ;
	int i ;
	
	hscmd = (data->hScroll & 0x30) >> 4 ;
	hsoff = data->hScroll & 0x0F ;
	vscmd = (data->vScroll & 0x30) >> 4 ;
	vsoff = data->vScroll & 0x0F ;
	
	if(!hscmd && hsoff) {
		/* Commit any horizontal offset scroll that might exist */
	}
	else if(hscmd == 1) {
		/* Commit 6 pixels of horizontal right scroll */
	}
	else if(hscmd == 2) {
		/* Commit 5 pixels of horizontal left scroll */
	}
	
	if(!vscmd && vsoff) {
		/* Commit any vertical offset scroll that might exist */
	}
	else if(vscmd == 1) {
		memmove(&stream->pixelMatrix[CDG_FRAMEWIDTH*12], stream->pixelMatrix, (CDG_FRAMEWIDTH*CDG_FRAMEHEIGHT)-(CDG_FRAMEWIDTH*12)) ;
		memset(stream->pixelMatrix,data->color,CDG_FRAMEWIDTH*12) ;
	}
	else if(vscmd == 2) {
		memmove(stream->pixelMatrix, &stream->pixelMatrix[CDG_FRAMEWIDTH*12], (CDG_FRAMEWIDTH*CDG_FRAMEHEIGHT)-(CDG_FRAMEWIDTH*12)) ;
		memset(&stream->pixelMatrix[(CDG_FRAMEWIDTH*CDG_FRAMEHEIGHT)-(CDG_FRAMEWIDTH*12)], data->color,CDG_FRAMEWIDTH*12) ;
	}
  
 }
 
 