------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2003                            --
--                                ACT-Europe                                --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--  As a special exception, if other files instantiate generics from this   --
--  unit, or you link this unit with other files to produce an executable,  --
--  this  unit  does not  by itself cause  the resulting executable to be   --
--  covered by the GNU General Public License. This exception does not      --
--  however invalidate any other reasons why the executable file  might be  --
--  covered by the  GNU Public License.                                     --
------------------------------------------------------------------------------

--  $Id: huge_response.adb,v 1.3 2003/12/02 11:47:23 anisimko Exp $

with Ada.Strings.Unbounded;
with Ada.Text_IO;

with AWS.Client;
with AWS.MIME;
with AWS.Response.Set;
with AWS.Server;
with AWS.Status;

procedure Huge_Response is

   use Ada;
   use Ada.Strings.Unbounded;
   use AWS;

   Len_Message : constant := 20_000_000;
   Sample      : constant String  := "0123456789";
   Message     : Unbounded_String := (Len_Message / Sample'Length) * Sample;

   WS : Server.HTTP;

   function CB (Request : in Status.Data) return Response.Data is
   begin
      return Response.Build (MIME.Text_HTML, Message);
   end CB;

   R : Response.Data;

begin
   Server.Start
     (WS, "huge_message",
      CB'Unrestricted_Access,
      Port           => 1257,
      Max_Connection => 5);

   Ada.Text_IO.Put_Line ("started"); Ada.Text_IO.Flush;

   R := Client.Get ("http://localhost:1257");

   if Message = Unbounded_String'(Response.Message_Body (R)) then
      Text_IO.Put_Line ("Ok");
   else
      Text_IO.Put_Line ("Nok: " & To_String (Response.Message_Body (R)));
   end if;

   Server.Shutdown (WS);
   Ada.Text_IO.Put_Line ("shutdown");
end Huge_Response;
