/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: console.c,v 1.5 2001/11/10 00:44:13 martine Exp $
 */
#include "config.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "util.h"
#include "network.h"

typedef struct {
	GtkWidget *win;
	GtkWidget *entry, *display;
	GdkFont *fixedfont;
} console_dlg;

#define FIXED_FONT_DESC "-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*"

static void
console_print(console_dlg *cdlg, char *type, int fixed, char *text, ...) {
	gint pos;
	char buf[4096];
	va_list ap;

	GdkColor info  = { 0, 0, 256*128, 0 },
	         error = { 0, 256*255, 0, 0 };

	GdkColor *color = NULL;

	if (type) {
		if (strcmp(type, "info") == 0) {
			color = &info;
		} else if (strcmp(type, "error") == 0) {
			color = &error;
		}
	}

	va_start(ap, text);
	vsnprintf(buf, 4096, text, ap);
	va_end(ap);

	pos = gtk_text_get_length(GTK_TEXT(cdlg->display));
	gtk_text_set_point(GTK_TEXT(cdlg->display), pos);
	gtk_text_insert(GTK_TEXT(cdlg->display), 
			fixed ? cdlg->fixedfont : NULL, color, NULL,
			buf, -1);
}

static void
submit_cb(GtkWidget *w, console_dlg *cdlg) {
	GHashTable *request, *result;
	char *command, *value;

	request = net_request_new("consolecommand");

	command = gtk_editable_get_chars(GTK_EDITABLE(cdlg->entry), 0, -1);
	g_hash_table_insert(request, g_strdup("command"), command);
	console_print(cdlg, NULL, 0, "Running command: '");
	console_print(cdlg, NULL, 1, command);
	console_print(cdlg, NULL, 0, "'.\n");

	result = net_request_run(cdlg->win, "Running Command...", request);
	hash_destroy(request);

	if (!net_request_succeeded(result)) {
		console_print(cdlg, "error", 0, "Error running command.\n");
		hash_destroy(result);
		return;
	}

	/* if we succeeded, erase the old entry text. */
	gtk_editable_delete_text(GTK_EDITABLE(cdlg->entry), 0, -1);

	if ((value = g_hash_table_lookup(result, "cmd_line_count")) != NULL) {
		int line, linecount;
		char *linetext, *linetype;
		char buf[30];
		linecount = atoi(value);

		for (line = 1; line <= linecount; line++) {
			sprintf(buf, "cmd_line_%d", line);
			linetext = g_hash_table_lookup(result, buf);
			sprintf(buf, "cmd_line_%d_type", line);
			linetype = g_hash_table_lookup(result, buf);

			console_print(cdlg, linetype, 1, linetext);
			console_print(cdlg, linetype, 1, "\n");
		}

	}
	
	hash_destroy(result);
}

static void
console_help(GtkWidget *w, console_dlg *cdlg) {
	lj_messagebox(cdlg->win, "LiveJournal Console",
			"The LiveJournal console is used primarily for administrative commands.\n"
			"See http://www.livejournal.com/admin/console/reference.bml for details.");
}

void
console_dialog_run(GtkWidget *parent) {
	console_dlg cdlg_actual = {0}, *cdlg = &cdlg_actual;
	GtkWidget *vbox, *hbox, *button;

	cdlg->win = lj_dialog_new(parent, "LiveJournal Console", 300, 500);
	geometry_tie(cdlg->win, &conf.console_geom);
	gtk_signal_connect(GTK_OBJECT(cdlg->win), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	vbox = gtk_vbox_new(FALSE, 5);

	hbox = gtk_hbox_new(FALSE, 5);
	cdlg->entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), cdlg->entry, TRUE, TRUE, 0);

	button = gtk_button_new_with_label(" Submit ");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(cdlg->entry), "activate",
			GTK_SIGNAL_FUNC(submit_cb), cdlg);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(submit_cb), cdlg);

	button = gtk_button_new_with_label(" ? ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(console_help), cdlg);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	cdlg->display = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), scroll_wrap(cdlg->display), TRUE, TRUE, 0);

	lj_dialog_add_close(cdlg->win);

	lj_dialog_set_contents(cdlg->win, vbox);

	cdlg->fixedfont = gdk_font_load(FIXED_FONT_DESC);

	console_print(cdlg, NULL, 0, "LiveJournal console ready.\n");
	gtk_widget_show(cdlg->win);
	gtk_main();

	gdk_font_unref(cdlg->fixedfont);
}
