#pragma implementation
#include "uucp.h"
#include <misc.h>
#include "uucp.m"
#include "internal.h"
#include <userconf.h>
#include "../paths.h"
#include <dialog.h>
#include <string.h>

extern UUCP_HELP_FILE help_uucp;
static UUCP_HELP_FILE help_uucptasks("tasks");

/*
	Main menu of uucp management
*/
void uucp_edit ()
{
	int choice=0;
	static const char *systems = MSG_U(M_SYSTEMS,"systems");
	static const char *devices = MSG_U(M_HOSTS,"devices and modems");
	static const char *tasks   = MSG_U(M_TASKS,"scheduled tasks");
	static const char *menuopt[]={
		MSG_U(M_CONFIG,"Configure"),		systems,
		"",		devices,
		"",		tasks,
		NULL
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	while (1){
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_UUCP,"UUCP configurator")
			,MSG_U(I_UUCP,"This package allows you to configure from\n"
			 "scratch a UUCP network using modem\n"
			 "and serial devices")
			,help_uucp
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == systems){
				system_edit();
			}else if (key == devices){
				devices_edit();
			}else if (key == tasks){
				if (cron_isempty("uucp")){
					if (dialog_yesno(
						MSG_U(Q_INSTALLTASKS,"Install standard uucp tasks")
						,MSG_U(I_INSTALLTASKS
							,"UUCP requires some scheduled tasks to operate.\n"
							 "There is no tasks configured on your system.\n"
							 "Do you want to install preset values ?")
						,help_uucptasks)==MENU_YES){
						cron_install("uucp",USR_LIB_LINUXCONF_UUCPTASKS);
					}
				}
				static const char *tb[][2]={
					{"/usr/sbin/uucico -r1",
							MSG_U(O_UUCICO,"Process the outbound queue")},
					{"/usr/lib/linuxconf/uucp/uucp.poll",
							MSG_U(O_POLL,"Generate poll requests")},
					{"/usr/lib/linuxconf/uucp/uucp.cleanup",
							MSG_U(O_CLEANUP,"Cleanup the different logs")},
					{NULL,NULL}
				};
				cron_edit ("uucp",tb);
			}
		}
	}
}

static void uucp_usage ()
{
	xconf_error ("%s\n"
		"uucpconf --connect site\n"
		"\n"
		"%s\n"
		,MSG_U(E_NETCONF,"uucpconf: Invalid arguments\n")
		,MSG_U(E_NETCONFDEF,"uucpconf without argument start the interactive mode\n"
		"\n")
		);
}
int uucp_main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 1){
		uucp_edit();
		ret = 0;
	}else if (argc == 3){
		char *arg1 = argv[1];
		if (strcmp(arg1,"--connect")==0){
			/* #Specification: uucpconf / option / --connect
				uucpconf --connect "system" establish a connexion (forced)
				to a uucp site.
			*/
			xconf_notice (MSG_U(E_NOTDONE,"Not done yet, sorry!"));
		}else{
			uucp_usage();
		}
	}else{
		uucp_usage();
	}
	return ret;
}

