#!/bin/sh
# Support function to create linuxconf script modules
if [ "$DBGSHELLMOD" = "on" ] ; then
	rm -f /tmp/shellmod.log
fi
# The dispatch function is used at the end of all shellmod script
# and whenever a result is expect from shellmod or Linuxconf.
dispatch(){
	while true
	do
		read -r cmd line
		if [ "$DBGSHELLMOD" = "on" ] ; then
			echo line=$cmd $line >>/tmp/shellmod.log
		fi
		if [ "$cmd" = "" ] ; then
			exit
		elif [ "$cmd" = "go" ] ; then
			break;
		elif [ "$cmd" = "exec" ] ; then
			eval $line
			echo endscope
		else
			eval $cmd $line
		fi
	done
}

# Used after few vreg_set or vreg_get statements
vreg_do(){
	echo vreg_do
	dispatch
}

# Popup a confirmation dialog
# The variable CODE will contain either "yes" or "no"
# The first argument is the title of the dialog. The second is
# the longer dialog introduction
# yesno "Are you sure" "Do you want to remove the file /tmp/foo"
# if [ "$CODE" = "yes" ] ; then
#		rm -f /tmp/foo
# fi
yesno(){
	echo yesno \"$1\" \"$2\"
	dispatch
}
# Replacement for the echo function for those tired of using \" construct
# to quote multiple word argument. With qecho, you can use normal shell
# quoting
qecho(){
	echo -n $1
	shift
	while [ $# -gt 0 ]
	do
		echo -n " " \"$1\"
		shift
	done
	echo
}

