#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
LCMetaData_lcstrings(LCMetaDataObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return LCStrings_FromStrings((SSTRINGS*)self->v);
}

static PyObject *
LCMetaData_lcstring(LCMetaDataObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return LCString_FromString((SSTRING*)self->v);
}

static PyObject *
LCMetaData_lccharp(LCMetaDataObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return LCString_FromStringDealloc(new SSTRING((char*)self->v));
}

static PyObject *
LCMetaData_lcchar(LCMetaDataObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return LCChar_New((char)self->v);
}

static PyObject *
LCMetaData_lcint(LCMetaDataObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return LCInt_New((int)self->v);
}

static struct PyMethodDef LCMetaData_methods[] = {
	{"lcstring", (binaryfunc) LCMetaData_lcstring, 1},
	{"lcstrings", (binaryfunc) LCMetaData_lcstrings, 1},
	{"lccharp", (binaryfunc) LCMetaData_lccharp, 1},
	{"lcchar", (binaryfunc) LCMetaData_lcchar, 1},
	{"lcint", (binaryfunc) LCMetaData_lcint, 1},
	{NULL, NULL}
};

static void
LCMetaData_dealloc(LCMetaDataObject *self)
{
	if (self->owner)
		free(self->v);
	PyMem_DEL(self);
}

static PyObject *
LCMetaData_getattr(LCMetaDataObject *self, char *name)
{
	return Py_FindMethod(LCMetaData_methods, (PyObject*) self, name);
}

PyTypeObject LCMetaData_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCMetaData",
	sizeof(LCMetaDataObject),
	0,
	(destructor) LCMetaData_dealloc,
	(printfunc) 0,
	(getattrfunc) LCMetaData_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCMetaData_New(void *v)
{
	LCMetaDataObject *self;
	self = PyObject_NEW(LCMetaDataObject, &LCMetaData_Type);
	if (self == NULL)
		return NULL;
	self->v = v;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCMetaData_NewDealloc(void *v)
{
	LCMetaDataObject *self;
	self = PyObject_NEW(LCMetaDataObject, &LCMetaData_Type);
	if (self == NULL)
		return NULL;
	self->v = v;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcmetadata_LCMetaData(PyObject *self, PyObject *args)
{
	void *v;
	if (!PyArg_ParseTuple(args, "i", &v))
		return NULL;
	return LCMetaData_New(v);
}

static struct PyMethodDef lcmetadata_methods[] = {
	{"LCMetaData", lcmetadata_LCMetaData, 1},
	{NULL,NULL}
};

extern "C" void
initlcmetadata()
{
	PyObject *m, *d;
	m = Py_InitModule("lcmetadata", lcmetadata_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcmetadata.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcmetadata");
}
